#include <stdio.h>
#include <stdbool.h>
#include <unistd.h>
#include <sys/types.h>
#include <dirent.h>

#include <sock.h>
#include <mpl.h>

int writedirlist (char *dir, char *file)
{
	FILE *filep;
	DIR *dirp;
	struct dirent *dire;
	
	filep=fopen(file, "w");
	
	if (!filep)
	{
		perror(file);
		return 1;
	}
	
	dirp=opendir(dir);
	
	if (!dirp)
	{
		perror(dir);
		return 1;
	}
	
	while ((dire=readdir(dirp))&&(dire))
		if (strncmp(dire->d_name, ".", 1))
			fprintf (filep, "%s/%s\n", dir, dire->d_name);
	
	closedir(dirp);
	fclose(filep);
}

int main (int argc, char **argv)
{
	int pid;
	FILE *mpl;
	bool run;
	char *buf, *cmd;
	sock srv_sock, cl_sock;

	pid=fork();
	if (pid==-1) 
	{
		perror("ltmp: fork");
		exit(1);
	}
	if (pid) 
		exit(0);

	run=true;
	mpl=fopen(LOGFILE, "r");
	if (mpl)
		return 0;	
	writedirlist(MUSICDIR, PLLIST);
	cmd=(char *)malloc(256);
	snprintf(cmd, 255, 
		"mplayer -slave -playlist %s -shuffle -quiet >%s 2>&1", 
		PLLIST, LOGFILE);
	mpl=popen(cmd, "w"); 
	
	if ((!mpl)||(setvbuf(mpl, NULL, _IONBF, 0)!=0))
	{
		perror("mpl-srv");
		return 1;
	}
	
	sock_open(&srv_sock, MPL_SOCK, -1);
	sock_bind(&srv_sock);
	sock_listen(&srv_sock, 1);

	while (run)
	{
		sock_accept(&srv_sock, &cl_sock);
		buf=sock_read(&cl_sock, 10);
		sock_close(&cl_sock, false);
		
		fprintf(mpl, "%s\n", buf);
		if (!strcmp(buf, "quit"))
			run=false;
		free(buf);
	}

	pclose(mpl);
	sock_close(&srv_sock, false);
	unlink(MPL_SOCK);
	unlink(LOGFILE);
	unlink(PLLIST);
	return 0; 
}
