#include <stdio.h>
#include <gkrellm2/gkrellm.h>

#include <mpl.h>

#define	CONFIG_NAME	"LTMP"
#define	STYLE_NAME	"ltmp"
#define DELAY		10

static GkrellmMonitor	*monitor;
static GkrellmPanel		*panel;
static GkrellmStyle		*style;
static GkrellmDecal		*text;
static GkrellmTicks		*tick;
static gint				style_id, offs;
static gchar			*scrolltxt;

static void update_plugin()
{
	gchar *foo, *cmd;
	FILE *info;

	if ((tick->timer_ticks % DELAY) == 0)
	{
		foo=g_malloc(256);
		cmd=g_malloc(256);
		snprintf(cmd, 255, "%s/bin/mpl-info <%s", BASEDIR, LOGFILE);
		info=popen(cmd, "r");
		g_free(cmd);
		fgets(foo, 255, info);
		fclose(info);
		
		if ((!scrolltxt)||(strcmp(scrolltxt, foo)))
		{
			if (scrolltxt)
				free(scrolltxt);
			scrolltxt=g_malloc(256);
			strcpy(scrolltxt, foo);
			offs=1;
		}
		
		g_free(foo);
	}
	
	offs = (offs - 1) % gkrellm_chart_width();
	text->x_off=offs;
	gkrellm_draw_decal_text(panel, text, scrolltxt, offs);
	gkrellm_draw_panel_layers(panel);
}

static gint panel_expose_event(GtkWidget *widget, GdkEventExpose *ev)
{
	gdk_draw_pixmap(widget->window,
            widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
            panel->pixmap, ev->area.x, ev->area.y, ev->area.x, ev->area.y,
            ev->area.width, ev->area.height);
    return FALSE;
}

static void create_plugin(GtkWidget *vbox, gint first_create)
{
	GkrellmTextstyle *ts;
	
	if (first_create)
		panel = gkrellm_panel_new0();

	style = gkrellm_meter_style(style_id);
	ts = gkrellm_meter_textstyle(style_id);
	text = gkrellm_create_decal_text(panel, "Foo", ts, style, -1, -1, -1);
	gkrellm_panel_configure(panel, NULL, style);
	gkrellm_panel_create(vbox, monitor, panel);
	
	if (first_create)
	    g_signal_connect(G_OBJECT (panel->drawing_area), "expose_event",
    	        G_CALLBACK(panel_expose_event), NULL);
}

static GkrellmMonitor plugin_mon =
{
	CONFIG_NAME,
	0,
	create_plugin,
	update_plugin,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	MON_MAIL,
	NULL,
	NULL
};


GkrellmMonitor *gkrellm_init_plugin(void)
{
	tick = gkrellm_ticks();
	style_id = gkrellm_add_meter_style(&plugin_mon, STYLE_NAME);
	monitor = &plugin_mon;
	return &plugin_mon;
}
