"// ambient+diffuse+specular+normalmap+attenuation+cubemap+fog shader\n"
"// written by Forest 'LordHavoc' Hale\n"
"// shadowmapping enhancements by Lee 'eihrul' Salzman\n"
"\n"
"#ifdef USECELSHADING\n"
"# define SHADEDIFFUSE myhalf diffuse = cast_myhalf(min(max(float(dot(surfacenormal, lightnormal)) * 2.0, 0.0), 1.0));\n"
"# ifdef USEEXACTSPECULARMATH\n"
"#  define SHADESPECULAR(specpow) myhalf specular = pow(cast_myhalf(max(float(dot(reflect(lightnormal, surfacenormal), eyenormal))*-1.0, 0.0)), 1.0 + specpow);specular = max(0.0, specular * 10.0 - 9.0);\n"
"# else\n"
"#  define SHADESPECULAR(specpow) myhalf3 specularnormal = normalize(lightnormal + eyenormal);myhalf specular = pow(cast_myhalf(max(float(dot(surfacenormal, specularnormal)), 0.0)), 1.0 + specpow);specular = max(0.0, specular * 10.0 - 9.0);\n"
"# endif\n"
"#else\n"
"# define SHADEDIFFUSE myhalf diffuse = cast_myhalf(max(float(dot(surfacenormal, lightnormal)), 0.0));\n"
"# ifdef USEEXACTSPECULARMATH\n"
"#  define SHADESPECULAR(specpow) myhalf specular = pow(cast_myhalf(max(float(dot(reflect(lightnormal, surfacenormal), eyenormal))*-1.0, 0.0)), 1.0 + specpow);\n"
"# else\n"
"#  define SHADESPECULAR(specpow) myhalf3 specularnormal = normalize(lightnormal + eyenormal);myhalf specular = pow(cast_myhalf(max(float(dot(surfacenormal, specularnormal)), 0.0)), 1.0 + specpow);\n"
"# endif\n"
"#endif\n"
"\n"
"#ifdef GLSL130\n"
"precision highp float;\n"
"# ifdef VERTEX_SHADER\n"
"#  define dp_varying out\n"
"#  define dp_attribute in\n"
"# endif\n"
"# ifdef FRAGMENT_SHADER\n"
"out vec4 dp_FragColor;\n"
"#  define dp_varying in\n"
"#  define dp_attribute in\n"
"# endif\n"
"# define dp_offsetmapping_dFdx dFdx\n"
"# define dp_offsetmapping_dFdy dFdy\n"
"# define dp_textureGrad textureGrad\n"
"# define dp_textureOffset(a,b,c,d) textureOffset(a,b,ivec2(c,d))\n"
"# define dp_texture2D texture\n"
"# define dp_texture3D texture\n"
"# define dp_textureCube texture\n"
"# define dp_shadow2D(a,b) float(texture(a,b))\n"
"#else\n"
"# ifdef FRAGMENT_SHADER\n"
"#  define dp_FragColor gl_FragColor\n"
"# endif\n"
"# define dp_varying varying\n"
"# define dp_attribute attribute\n"
"# define dp_offsetmapping_dFdx(a) vec2(0.0, 0.0)\n"
"# define dp_offsetmapping_dFdy(a) vec2(0.0, 0.0)\n"
"# define dp_textureGrad(a,b,c,d) texture2D(a,b)\n"
"# define dp_textureOffset(a,b,c,d) texture2DOffset(a,b,ivec2(c,d))\n"
"# define dp_texture2D texture2D\n"
"# define dp_texture3D texture3D\n"
"# define dp_textureCube textureCube\n"
"# define dp_shadow2D(a,b) float(shadow2D(a,b))\n"
"#endif\n"
"\n"
"// GL ES and GLSL130 shaders use precision modifiers, standard GL does not\n"
"// in GLSL130 we don't use them though because of syntax differences (can't use precision with inout)\n"
"#ifndef GL_ES\n"
"#define lowp\n"
"#define mediump\n"
"#define highp\n"
"#endif\n"
"\n"
"#ifdef USEDEPTHRGB\n"
"	// for 565 RGB we'd need to use different multipliers\n"
"#define decodedepthmacro(d) dot((d).rgb, vec3(1.0, 255.0 / 65536.0, 255.0 / 16777215.0))\n"
"#define encodedepthmacro(d) (vec4(d, d*256.0, d*65536.0, 0.0) - floor(vec4(d, d*256.0, d*65536.0, 0.0)))\n"
"#endif\n"
"\n"
"#ifdef VERTEX_SHADER\n"
"dp_attribute vec4 Attrib_Position;  // vertex\n"
"dp_attribute vec4 Attrib_Color;     // color\n"
"dp_attribute vec4 Attrib_TexCoord0; // material texcoords\n"
"dp_attribute vec3 Attrib_TexCoord1; // svector\n"
"dp_attribute vec3 Attrib_TexCoord2; // tvector\n"
"dp_attribute vec3 Attrib_TexCoord3; // normal\n"
"dp_attribute vec4 Attrib_TexCoord4; // lightmap texcoords\n"
"#endif\n"
"dp_varying mediump vec4 VertexColor;\n"
"\n"
"#if defined(USEFOGINSIDE) || defined(USEFOGOUTSIDE) || defined(USEFOGHEIGHTTEXTURE)\n"
"# define USEFOG\n"
"#endif\n"
"#if defined(MODE_LIGHTMAP) || defined(MODE_LIGHTDIRECTIONMAP_MODELSPACE) || defined(MODE_LIGHTDIRECTIONMAP_TANGENTSPACE) || defined(MODE_LIGHTDIRECTIONMAP_FORCED_LIGHTMAP)\n"
"# define USELIGHTMAP\n"
"#endif\n"
"#if defined(USESPECULAR) || defined(USEOFFSETMAPPING) || defined(USEREFLECTCUBE) || defined(MODE_FAKELIGHT) || defined(USEFOG)\n"
"# define USEEYEVECTOR\n"
"#endif\n"
"\n"
"#ifdef USESHADOWMAP2D\n"
"# ifdef GL_EXT_gpu_shader4\n"
"#   extension GL_EXT_gpu_shader4 : enable\n"
"# endif\n"
"# ifdef GL_ARB_texture_gather\n"
"#   extension GL_ARB_texture_gather : enable\n"
"# else\n"
"#   ifdef GL_AMD_texture_texture4\n"
"#     extension GL_AMD_texture_texture4 : enable\n"
"#   endif\n"
"# endif\n"
"#endif\n"
"\n"
"//#ifdef USESHADOWSAMPLER\n"
"//# extension GL_ARB_shadow : enable\n"
"//#endif\n"
"\n"
"//#ifdef __GLSL_CG_DATA_TYPES\n"
"//# define myhalf half\n"
"//# define myhalf2 half2\n"
"//# define myhalf3 half3\n"
"//# define myhalf4 half4\n"
"//# define cast_myhalf half\n"
"//# define cast_myhalf2 half2\n"
"//# define cast_myhalf3 half3\n"
"//# define cast_myhalf4 half4\n"
"//#else\n"
"# define myhalf mediump float\n"
"# define myhalf2 mediump vec2\n"
"# define myhalf3 mediump vec3\n"
"# define myhalf4 mediump vec4\n"
"# define cast_myhalf float\n"
"# define cast_myhalf2 vec2\n"
"# define cast_myhalf3 vec3\n"
"# define cast_myhalf4 vec4\n"
"//#endif\n"
"\n"
"#ifdef VERTEX_SHADER\n"
"uniform highp mat4 ModelViewProjectionMatrix;\n"
"#endif\n"
"\n"
"#ifdef VERTEX_SHADER\n"
"#ifdef USETRIPPY\n"
"// LordHavoc: based on shader code linked at: http://www.youtube.com/watch?v=JpksyojwqzE\n"
"// tweaked scale\n"
"uniform highp float ClientTime;\n"
"vec4 TrippyVertex(vec4 position)\n"
"{\n"
"	float worldTime = ClientTime;\n"
"	// tweaked for Quake\n"
"	worldTime *= 10.0;\n"
"	position *= 0.125;\n"
"	//~tweaked for Quake\n"
"	float distanceSquared = (position.x * position.x + position.z * position.z);\n"
"	position.y += 5.0*sin(distanceSquared*sin(worldTime/143.0)/1000.0);\n"
"	float y = position.y;\n"
"	float x = position.x;\n"
"	float om = sin(distanceSquared*sin(worldTime/256.0)/5000.0) * sin(worldTime/200.0);\n"
"	position.y = x*sin(om)+y*cos(om);\n"
"	position.x = x*cos(om)-y*sin(om);\n"
"	return position;\n"
"}\n"
"#endif\n"
"#endif\n"
"\n"
"#ifdef MODE_DEPTH_OR_SHADOW\n"
"dp_varying highp float Depth;\n"
"#ifdef VERTEX_SHADER\n"
"void main(void)\n"
"{\n"
"	gl_Position = ModelViewProjectionMatrix * Attrib_Position;\n"
"#ifdef USETRIPPY\n"
"	gl_Position = TrippyVertex(gl_Position);\n"
"#endif\n"
"	Depth = gl_Position.z;\n"
"}\n"
"#endif\n"
"\n"
"#ifdef FRAGMENT_SHADER\n"
"void main(void)\n"
"{\n"
"#ifdef USEDEPTHRGB\n"
"	dp_FragColor = encodedepthmacro(Depth);\n"
"#else\n"
"	dp_FragColor = vec4(1.0,1.0,1.0,1.0);\n"
"#endif\n"
"}\n"
"#endif\n"
"#else // !MODE_DEPTH_ORSHADOW\n"
"\n"
"\n"
"\n"
"\n"
"#ifdef MODE_SHOWDEPTH\n"
"#ifdef VERTEX_SHADER\n"
"void main(void)\n"
"{\n"
"	gl_Position = ModelViewProjectionMatrix * Attrib_Position;\n"
"	VertexColor = vec4(gl_Position.z, gl_Position.z, gl_Position.z, 1.0);\n"
"#ifdef USETRIPPY\n"
"	gl_Position = TrippyVertex(gl_Position);\n"
"#endif\n"
"}\n"
"#endif\n"
"\n"
"#ifdef FRAGMENT_SHADER\n"
"void main(void)\n"
"{\n"
"	dp_FragColor = VertexColor;\n"
"}\n"
"#endif\n"
"#else // !MODE_SHOWDEPTH\n"
"\n"
"\n"
"\n"
"\n"
"#ifdef MODE_POSTPROCESS\n"
"dp_varying mediump vec2 TexCoord1;\n"
"dp_varying mediump vec2 TexCoord2;\n"
"\n"
"#ifdef VERTEX_SHADER\n"
"void main(void)\n"
"{\n"
"	gl_Position = ModelViewProjectionMatrix * Attrib_Position;\n"
"	TexCoord1 = Attrib_TexCoord0.xy;\n"
"#ifdef USEBLOOM\n"
"	TexCoord2 = Attrib_TexCoord4.xy;\n"
"#endif\n"
"}\n"
"#endif\n"
"\n"
"#ifdef FRAGMENT_SHADER\n"
"uniform sampler2D Texture_First;\n"
"#ifdef USEBLOOM\n"
"uniform sampler2D Texture_Second;\n"
"uniform mediump vec4 BloomColorSubtract;\n"
"#endif\n"
"#ifdef USEGAMMARAMPS\n"
"uniform sampler2D Texture_GammaRamps;\n"
"#endif\n"
"#ifdef USESATURATION\n"
"uniform mediump float Saturation;\n"
"#endif\n"
"#ifdef USEVIEWTINT\n"
"uniform mediump vec4 ViewTintColor;\n"
"#endif\n"
"//uncomment these if you want to use them:\n"
"uniform mediump vec4 UserVec1;\n"
"uniform mediump vec4 UserVec2;\n"
"// uniform mediump vec4 UserVec3;\n"
"// uniform mediump vec4 UserVec4;\n"
"// uniform highp float ClientTime;\n"
"uniform mediump vec2 PixelSize;\n"
"void main(void)\n"
"{\n"
"	dp_FragColor = dp_texture2D(Texture_First, TexCoord1);\n"
"#ifdef USEBLOOM\n"
"	dp_FragColor += max(vec4(0,0,0,0), dp_texture2D(Texture_Second, TexCoord2) - BloomColorSubtract);\n"
"#endif\n"
"#ifdef USEVIEWTINT\n"
"	dp_FragColor = mix(dp_FragColor, ViewTintColor, ViewTintColor.a);\n"
"#endif\n"
"\n"
"#ifdef USEPOSTPROCESSING\n"
"// do r_glsl_dumpshader, edit glsl/default.glsl, and replace this by your own postprocessing if you want\n"
"// this code does a blur with the radius specified in the first component of r_glsl_postprocess_uservec1 and blends it using the second component\n"
"	float sobel = 1.0;\n"
"	// vec2 ts = textureSize(Texture_First, 0);\n"
"	// vec2 px = vec2(1/ts.x, 1/ts.y);\n"
"	vec2 px = PixelSize;\n"
"	vec3 x1 = dp_texture2D(Texture_First, TexCoord1 + vec2(-px.x, px.y)).rgb;\n"
"	vec3 x2 = dp_texture2D(Texture_First, TexCoord1 + vec2(-px.x,  0.0)).rgb;\n"
"	vec3 x3 = dp_texture2D(Texture_First, TexCoord1 + vec2(-px.x,-px.y)).rgb;\n"
"	vec3 x4 = dp_texture2D(Texture_First, TexCoord1 + vec2( px.x, px.y)).rgb;\n"
"	vec3 x5 = dp_texture2D(Texture_First, TexCoord1 + vec2( px.x,  0.0)).rgb;\n"
"	vec3 x6 = dp_texture2D(Texture_First, TexCoord1 + vec2( px.x,-px.y)).rgb;\n"
"	vec3 y1 = dp_texture2D(Texture_First, TexCoord1 + vec2( px.x,-px.y)).rgb;\n"
"	vec3 y2 = dp_texture2D(Texture_First, TexCoord1 + vec2(  0.0,-px.y)).rgb;\n"
"	vec3 y3 = dp_texture2D(Texture_First, TexCoord1 + vec2(-px.x,-px.y)).rgb;\n"
"	vec3 y4 = dp_texture2D(Texture_First, TexCoord1 + vec2( px.x, px.y)).rgb;\n"
"	vec3 y5 = dp_texture2D(Texture_First, TexCoord1 + vec2(  0.0, px.y)).rgb;\n"
"	vec3 y6 = dp_texture2D(Texture_First, TexCoord1 + vec2(-px.x, px.y)).rgb;\n"
"	float px1 = -1.0 * dot(vec3(0.3, 0.59, 0.11), x1);\n"
"	float px2 = -2.0 * dot(vec3(0.3, 0.59, 0.11), x2);\n"
"	float px3 = -1.0 * dot(vec3(0.3, 0.59, 0.11), x3);\n"
"	float px4 =  1.0 * dot(vec3(0.3, 0.59, 0.11), x4);\n"
"	float px5 =  2.0 * dot(vec3(0.3, 0.59, 0.11), x5);\n"
"	float px6 =  1.0 * dot(vec3(0.3, 0.59, 0.11), x6);\n"
"	float py1 = -1.0 * dot(vec3(0.3, 0.59, 0.11), y1);\n"
"	float py2 = -2.0 * dot(vec3(0.3, 0.59, 0.11), y2);\n"
"	float py3 = -1.0 * dot(vec3(0.3, 0.59, 0.11), y3);\n"
"	float py4 =  1.0 * dot(vec3(0.3, 0.59, 0.11), y4);\n"
"	float py5 =  2.0 * dot(vec3(0.3, 0.59, 0.11), y5);\n"
"	float py6 =  1.0 * dot(vec3(0.3, 0.59, 0.11), y6);\n"
"	sobel = 0.25 * abs(px1 + px2 + px3 + px4 + px5 + px6) + 0.25 * abs(py1 + py2 + py3 + py4 + py5 + py6);\n"
"	dp_FragColor += dp_texture2D(Texture_First, TexCoord1 + PixelSize*UserVec1.x*vec2(-0.987688, -0.156434)) * UserVec1.y;\n"
"	dp_FragColor += dp_texture2D(Texture_First, TexCoord1 + PixelSize*UserVec1.x*vec2(-0.156434, -0.891007)) * UserVec1.y;\n"
"	dp_FragColor += dp_texture2D(Texture_First, TexCoord1 + PixelSize*UserVec1.x*vec2( 0.891007, -0.453990)) * UserVec1.y;\n"
"	dp_FragColor += dp_texture2D(Texture_First, TexCoord1 + PixelSize*UserVec1.x*vec2( 0.707107,  0.707107)) * UserVec1.y;\n"
"	dp_FragColor += dp_texture2D(Texture_First, TexCoord1 + PixelSize*UserVec1.x*vec2(-0.453990,  0.891007)) * UserVec1.y;\n"
"	dp_FragColor /= (1.0 + 5.0 * UserVec1.y);\n"
"	dp_FragColor.rgb = dp_FragColor.rgb * (1.0 + UserVec2.x) + vec3(max(0.0, sobel - UserVec2.z))*UserVec2.y;\n"
"#endif\n"
"\n"
"#ifdef USESATURATION\n"
"	//apply saturation BEFORE gamma ramps, so v_glslgamma value does not matter\n"
"	float y = dot(dp_FragColor.rgb, vec3(0.299, 0.587, 0.114));\n"
"	// 'vampire sight' effect, wheres red is compensated\n"
"	#ifdef SATURATION_REDCOMPENSATE\n"
"		float rboost = max(0.0, (dp_FragColor.r - max(dp_FragColor.g, dp_FragColor.b))*(1.0 - Saturation));\n"
"		dp_FragColor.rgb = mix(vec3(y), dp_FragColor.rgb, Saturation);\n"
"		dp_FragColor.r += rboost;\n"
"	#else\n"
"		// normal desaturation\n"
"		//dp_FragColor = vec3(y) + (dp_FragColor.rgb - vec3(y)) * Saturation;\n"
"		dp_FragColor.rgb = mix(vec3(y), dp_FragColor.rgb, Saturation);\n"
"	#endif\n"
"#endif\n"
"\n"
"#ifdef USEGAMMARAMPS\n"
"	dp_FragColor.r = dp_texture2D(Texture_GammaRamps, vec2(dp_FragColor.r, 0)).r;\n"
"	dp_FragColor.g = dp_texture2D(Texture_GammaRamps, vec2(dp_FragColor.g, 0)).g;\n"
"	dp_FragColor.b = dp_texture2D(Texture_GammaRamps, vec2(dp_FragColor.b, 0)).b;\n"
"#endif\n"
"}\n"
"#endif\n"
"#else // !MODE_POSTPROCESS\n"
"\n"
"\n"
"\n"
"\n"
"#ifdef MODE_GENERIC\n"
"#ifdef USEDIFFUSE\n"
"dp_varying mediump vec2 TexCoord1;\n"
"#endif\n"
"#ifdef USESPECULAR\n"
"dp_varying mediump vec2 TexCoord2;\n"
"#endif\n"
"#ifdef VERTEX_SHADER\n"
"void main(void)\n"
"{\n"
"	VertexColor = Attrib_Color;\n"
"#ifdef USEDIFFUSE\n"
"	TexCoord1 = Attrib_TexCoord0.xy;\n"
"#endif\n"
"#ifdef USESPECULAR\n"
"	TexCoord2 = Attrib_TexCoord1.xy;\n"
"#endif\n"
"	gl_Position = ModelViewProjectionMatrix * Attrib_Position;\n"
"#ifdef USETRIPPY\n"
"	gl_Position = TrippyVertex(gl_Position);\n"
"#endif\n"
"}\n"
"#endif\n"
"\n"
"#ifdef FRAGMENT_SHADER\n"
"#ifdef USEDIFFUSE\n"
"uniform sampler2D Texture_First;\n"
"#endif\n"
"#ifdef USESPECULAR\n"
"uniform sampler2D Texture_Second;\n"
"#endif\n"
"#ifdef USEGAMMARAMPS\n"
"uniform sampler2D Texture_GammaRamps;\n"
"#endif\n"
"\n"
"void main(void)\n"
"{\n"
"#ifdef USEVIEWTINT\n"
"	dp_FragColor = VertexColor;\n"
"#else\n"
"	dp_FragColor = vec4(1.0, 1.0, 1.0, 1.0);\n"
"#endif\n"
"#ifdef USEDIFFUSE\n"
"# ifdef USEREFLECTCUBE\n"
"	// suppress texture alpha\n"
"	dp_FragColor.rgb *= dp_texture2D(Texture_First, TexCoord1).rgb;\n"
"# else\n"
"	dp_FragColor *= dp_texture2D(Texture_First, TexCoord1);\n"
"# endif\n"
"#endif\n"
"\n"
"#ifdef USESPECULAR\n"
"	vec4 tex2 = dp_texture2D(Texture_Second, TexCoord2);\n"
"# ifdef USECOLORMAPPING\n"
"	dp_FragColor *= tex2;\n"
"# endif\n"
"# ifdef USEGLOW\n"
"	dp_FragColor += tex2;\n"
"# endif\n"
"# ifdef USEVERTEXTEXTUREBLEND\n"
"	dp_FragColor = mix(dp_FragColor, tex2, tex2.a);\n"
"# endif\n"
"#endif\n"
"#ifdef USEGAMMARAMPS\n"
"	dp_FragColor.r = dp_texture2D(Texture_GammaRamps, vec2(dp_FragColor.r, 0)).r;\n"
"	dp_FragColor.g = dp_texture2D(Texture_GammaRamps, vec2(dp_FragColor.g, 0)).g;\n"
"	dp_FragColor.b = dp_texture2D(Texture_GammaRamps, vec2(dp_FragColor.b, 0)).b;\n"
"#endif\n"
"}\n"
"#endif\n"
"#else // !MODE_GENERIC\n"
"\n"
"\n"
"\n"
"\n"
"#ifdef MODE_BLOOMBLUR\n"
"dp_varying mediump vec2 TexCoord;\n"
"#ifdef VERTEX_SHADER\n"
"void main(void)\n"
"{\n"
"	VertexColor = Attrib_Color;\n"
"	TexCoord = Attrib_TexCoord0.xy;\n"
"	gl_Position = ModelViewProjectionMatrix * Attrib_Position;\n"
"}\n"
"#endif\n"
"\n"
"#ifdef FRAGMENT_SHADER\n"
"uniform sampler2D Texture_First;\n"
"uniform mediump vec4 BloomBlur_Parameters;\n"
"\n"
"void main(void)\n"
"{\n"
"	int i;\n"
"	vec2 tc = TexCoord;\n"
"	vec3 color = dp_texture2D(Texture_First, tc).rgb;\n"
"	tc += BloomBlur_Parameters.xy;\n"
"	for (i = 1;i < SAMPLES;i++)\n"
"	{\n"
"		color += dp_texture2D(Texture_First, tc).rgb;\n"
"		tc += BloomBlur_Parameters.xy;\n"
"	}\n"
"	dp_FragColor = vec4(color * BloomBlur_Parameters.z + vec3(BloomBlur_Parameters.w), 1);\n"
"}\n"
"#endif\n"
"#else // !MODE_BLOOMBLUR\n"
"#ifdef MODE_REFRACTION\n"
"dp_varying mediump vec2 TexCoord;\n"
"dp_varying highp vec4 ModelViewProjectionPosition;\n"
"uniform highp mat4 TexMatrix;\n"
"#ifdef VERTEX_SHADER\n"
"\n"
"void main(void)\n"
"{\n"
"#ifdef USEALPHAGENVERTEX\n"
"	VertexColor = Attrib_Color;\n"
"#endif\n"
"	TexCoord = vec2(TexMatrix * Attrib_TexCoord0);\n"
"	gl_Position = ModelViewProjectionMatrix * Attrib_Position;\n"
"	ModelViewProjectionPosition = gl_Position;\n"
"#ifdef USETRIPPY\n"
"	gl_Position = TrippyVertex(gl_Position);\n"
"#endif\n"
"}\n"
"#endif\n"
"\n"
"#ifdef FRAGMENT_SHADER\n"
"uniform sampler2D Texture_Normal;\n"
"uniform sampler2D Texture_Refraction;\n"
"\n"
"uniform mediump vec4 DistortScaleRefractReflect;\n"
"uniform mediump vec4 ScreenScaleRefractReflect;\n"
"uniform mediump vec4 ScreenCenterRefractReflect;\n"
"uniform mediump vec4 RefractColor;\n"
"uniform mediump vec4 ReflectColor;\n"
"uniform highp float ClientTime;\n"
"#ifdef USENORMALMAPSCROLLBLEND\n"
"uniform highp vec2 NormalmapScrollBlend;\n"
"#endif\n"
"\n"
"void main(void)\n"
"{\n"
"	vec2 ScreenScaleRefractReflectIW = ScreenScaleRefractReflect.xy * (1.0 / ModelViewProjectionPosition.w);\n"
"	//vec2 ScreenTexCoord = (ModelViewProjectionPosition.xy + normalize(vec3(dp_texture2D(Texture_Normal, TexCoord)) - vec3(0.5)).xy * DistortScaleRefractReflect.xy * 100) * ScreenScaleRefractReflectIW + ScreenCenterRefractReflect.xy;\n"
"	vec2 SafeScreenTexCoord = ModelViewProjectionPosition.xy * ScreenScaleRefractReflectIW + ScreenCenterRefractReflect.xy;\n"
"#ifdef USEALPHAGENVERTEX\n"
"	vec2 distort = DistortScaleRefractReflect.xy * VertexColor.a;\n"
"	vec4 refractcolor = mix(RefractColor, vec4(1.0, 1.0, 1.0, 1.0), VertexColor.a);\n"
"#else\n"
"	vec2 distort = DistortScaleRefractReflect.xy;\n"
"	vec4 refractcolor = RefractColor;\n"
"#endif\n"
"	#ifdef USENORMALMAPSCROLLBLEND\n"
"		vec3 normal = dp_texture2D(Texture_Normal, (TexCoord + vec2(0.08, 0.08)*ClientTime*NormalmapScrollBlend.x*0.5)*NormalmapScrollBlend.y).rgb - vec3(1.0);\n"
"		normal += dp_texture2D(Texture_Normal, (TexCoord + vec2(-0.06, -0.09)*ClientTime*NormalmapScrollBlend.x)*NormalmapScrollBlend.y*0.75).rgb;\n"
"		vec2 ScreenTexCoord = SafeScreenTexCoord + vec3(normalize(cast_myhalf3(normal))).xy * distort;\n"
"	#else\n"
"		vec2 ScreenTexCoord = SafeScreenTexCoord + vec3(normalize(cast_myhalf3(dp_texture2D(Texture_Normal, TexCoord)) - cast_myhalf3(0.5))).xy * distort;\n"
"	#endif\n"
"	// FIXME temporary hack to detect the case that the reflection\n"
"	// gets blackened at edges due to leaving the area that contains actual\n"
"	// content.\n"
"	// Remove this 'ack once we have a better way to stop this thing from\n"
"	// 'appening.\n"
"	float f = min(1.0, length(dp_texture2D(Texture_Refraction, ScreenTexCoord + vec2(0.01, 0.01)).rgb) / 0.05);\n"
"	f      *= min(1.0, length(dp_texture2D(Texture_Refraction, ScreenTexCoord + vec2(0.01, -0.01)).rgb) / 0.05);\n"
"	f      *= min(1.0, length(dp_texture2D(Texture_Refraction, ScreenTexCoord + vec2(-0.01, 0.01)).rgb) / 0.05);\n"
"	f      *= min(1.0, length(dp_texture2D(Texture_Refraction, ScreenTexCoord + vec2(-0.01, -0.01)).rgb) / 0.05);\n"
"	ScreenTexCoord = mix(SafeScreenTexCoord, ScreenTexCoord, f);\n"
"	dp_FragColor = vec4(dp_texture2D(Texture_Refraction, ScreenTexCoord).rgb, 1.0) * refractcolor;\n"
"}\n"
"#endif\n"
"#else // !MODE_REFRACTION\n"
"\n"
"\n"
"\n"
"\n"
"#ifdef MODE_WATER\n"
"dp_varying mediump vec2 TexCoord;\n"
"dp_varying highp vec3 EyeVector;\n"
"dp_varying highp vec4 ModelViewProjectionPosition;\n"
"#ifdef VERTEX_SHADER\n"
"uniform highp vec3 EyePosition;\n"
"uniform highp mat4 TexMatrix;\n"
"\n"
"void main(void)\n"
"{\n"
"#ifdef USEALPHAGENVERTEX\n"
"	VertexColor = Attrib_Color;\n"
"#endif\n"
"	TexCoord = vec2(TexMatrix * Attrib_TexCoord0);\n"
"	vec3 EyeRelative = EyePosition - Attrib_Position.xyz;\n"
"	EyeVector.x = dot(EyeRelative, Attrib_TexCoord1.xyz);\n"
"	EyeVector.y = dot(EyeRelative, Attrib_TexCoord2.xyz);\n"
"	EyeVector.z = dot(EyeRelative, Attrib_TexCoord3.xyz);\n"
"	gl_Position = ModelViewProjectionMatrix * Attrib_Position;\n"
"	ModelViewProjectionPosition = gl_Position;\n"
"#ifdef USETRIPPY\n"
"	gl_Position = TrippyVertex(gl_Position);\n"
"#endif\n"
"}\n"
"#endif\n"
"\n"
"#ifdef FRAGMENT_SHADER\n"
"uniform sampler2D Texture_Normal;\n"
"uniform sampler2D Texture_Refraction;\n"
"uniform sampler2D Texture_Reflection;\n"
"\n"
"uniform mediump vec4 DistortScaleRefractReflect;\n"
"uniform mediump vec4 ScreenScaleRefractReflect;\n"
"uniform mediump vec4 ScreenCenterRefractReflect;\n"
"uniform mediump vec4 RefractColor;\n"
"uniform mediump vec4 ReflectColor;\n"
"uniform mediump float ReflectFactor;\n"
"uniform mediump float ReflectOffset;\n"
"uniform highp float ClientTime;\n"
"#ifdef USENORMALMAPSCROLLBLEND\n"
"uniform highp vec2 NormalmapScrollBlend;\n"
"#endif\n"
"\n"
"void main(void)\n"
"{\n"
"	vec4 ScreenScaleRefractReflectIW = ScreenScaleRefractReflect * (1.0 / ModelViewProjectionPosition.w);\n"
"	//vec4 ScreenTexCoord = (ModelViewProjectionPosition.xyxy + normalize(vec3(dp_texture2D(Texture_Normal, TexCoord)) - vec3(0.5)).xyxy * DistortScaleRefractReflect * 100) * ScreenScaleRefractReflectIW + ScreenCenterRefractReflect;\n"
"	vec4 SafeScreenTexCoord = ModelViewProjectionPosition.xyxy * ScreenScaleRefractReflectIW + ScreenCenterRefractReflect;\n"
"	//SafeScreenTexCoord = gl_FragCoord.xyxy * vec4(1.0 / 1920.0, 1.0 / 1200.0, 1.0 / 1920.0, 1.0 / 1200.0);\n"
"	// slight water animation via 2 layer scrolling (todo: tweak)\n"
"#ifdef USEALPHAGENVERTEX\n"
"	vec4 distort = DistortScaleRefractReflect * VertexColor.a;\n"
"	float reflectoffset = ReflectOffset * VertexColor.a;\n"
"	float reflectfactor = ReflectFactor * VertexColor.a;\n"
"	vec4 refractcolor = mix(RefractColor, vec4(1.0, 1.0, 1.0, 1.0), VertexColor.a);\n"
"#else\n"
"	vec4 distort = DistortScaleRefractReflect;\n"
"	float reflectoffset = ReflectOffset;\n"
"	float reflectfactor = ReflectFactor;\n"
"	vec4 refractcolor = RefractColor;\n"
"#endif\n"
"	#ifdef USENORMALMAPSCROLLBLEND\n"
"		vec3 normal = dp_texture2D(Texture_Normal, (TexCoord + vec2(0.08, 0.08)*ClientTime*NormalmapScrollBlend.x*0.5)*NormalmapScrollBlend.y).rgb - vec3(1.0);\n"
"		normal += dp_texture2D(Texture_Normal, (TexCoord + vec2(-0.06, -0.09)*ClientTime*NormalmapScrollBlend.x)*NormalmapScrollBlend.y*0.75).rgb;\n"
"		vec4 ScreenTexCoord = SafeScreenTexCoord + vec2(normalize(normal) + vec3(0.15)).xyxy * distort;\n"
"	#else\n"
"		vec4 ScreenTexCoord = SafeScreenTexCoord + vec2(normalize(vec3(dp_texture2D(Texture_Normal, TexCoord)) - vec3(0.5))).xyxy * distort;\n"
"	#endif\n"
"	// FIXME temporary hack to detect the case that the reflection\n"
"	// gets blackened at edges due to leaving the area that contains actual\n"
"	// content.\n"
"	// Remove this 'ack once we have a better way to stop this thing from\n"
"	// 'appening.\n"
"	float f  = min(1.0, length(dp_texture2D(Texture_Refraction, ScreenTexCoord.xy + vec2(0.005, 0.01)).rgb) / 0.002);\n"
"	f       *= min(1.0, length(dp_texture2D(Texture_Refraction, ScreenTexCoord.xy + vec2(0.005, -0.01)).rgb) / 0.002);\n"
"	f       *= min(1.0, length(dp_texture2D(Texture_Refraction, ScreenTexCoord.xy + vec2(-0.005, 0.01)).rgb) / 0.002);\n"
"	f       *= min(1.0, length(dp_texture2D(Texture_Refraction, ScreenTexCoord.xy + vec2(-0.005, -0.01)).rgb) / 0.002);\n"
"	ScreenTexCoord.xy = mix(SafeScreenTexCoord.xy, ScreenTexCoord.xy, f);\n"
"	f  = min(1.0, length(dp_texture2D(Texture_Reflection, ScreenTexCoord.zw + vec2(0.005, 0.005)).rgb) / 0.002);\n"
"	f *= min(1.0, length(dp_texture2D(Texture_Reflection, ScreenTexCoord.zw + vec2(0.005, -0.005)).rgb) / 0.002);\n"
"	f *= min(1.0, length(dp_texture2D(Texture_Reflection, ScreenTexCoord.zw + vec2(-0.005, 0.005)).rgb) / 0.002);\n"
"	f *= min(1.0, length(dp_texture2D(Texture_Reflection, ScreenTexCoord.zw + vec2(-0.005, -0.005)).rgb) / 0.002);\n"
"	ScreenTexCoord.zw = mix(SafeScreenTexCoord.zw, ScreenTexCoord.zw, f);\n"
"	float Fresnel = pow(min(1.0, 1.0 - float(normalize(EyeVector).z)), 2.0) * reflectfactor + reflectoffset;\n"
"	dp_FragColor = mix(vec4(dp_texture2D(Texture_Refraction, ScreenTexCoord.xy).rgb, 1) * refractcolor, vec4(dp_texture2D(Texture_Reflection, ScreenTexCoord.zw).rgb, 1) * ReflectColor, Fresnel);\n"
"}\n"
"#endif\n"
"#else // !MODE_WATER\n"
"\n"
"\n"
"\n"
"\n"
"// common definitions between vertex shader and fragment shader:\n"
"\n"
"dp_varying mediump vec4 TexCoordSurfaceLightmap;\n"
"#ifdef USEVERTEXTEXTUREBLEND\n"
"dp_varying mediump vec2 TexCoord2;\n"
"#endif\n"
"\n"
"#ifdef MODE_LIGHTSOURCE\n"
"dp_varying mediump vec3 CubeVector;\n"
"#endif\n"
"\n"
"#if (defined(MODE_LIGHTSOURCE) || defined(MODE_LIGHTDIRECTION)) && defined(USEDIFFUSE)\n"
"dp_varying mediump vec3 LightVector;\n"
"#endif\n"
"\n"
"#ifdef USEEYEVECTOR\n"
"dp_varying highp vec4 EyeVectorFogDepth;\n"
"#endif\n"
"\n"
"#if defined(MODE_LIGHTDIRECTIONMAP_MODELSPACE) || defined(MODE_DEFERREDGEOMETRY) || defined(USEREFLECTCUBE) || defined(USEBOUNCEGRIDDIRECTIONAL)\n"
"dp_varying highp vec4 VectorS; // direction of S texcoord (sometimes crudely called tangent)\n"
"dp_varying highp vec4 VectorT; // direction of T texcoord (sometimes crudely called binormal)\n"
"dp_varying highp vec4 VectorR; // direction of R texcoord (surface normal)\n"
"#else\n"
"# ifdef USEFOG\n"
"dp_varying highp vec3 EyeVectorModelSpace;\n"
"# endif\n"
"#endif\n"
"\n"
"#ifdef USEREFLECTION\n"
"dp_varying highp vec4 ModelViewProjectionPosition;\n"
"#endif\n"
"#ifdef MODE_DEFERREDLIGHTSOURCE\n"
"uniform highp vec3 LightPosition;\n"
"dp_varying highp vec4 ModelViewPosition;\n"
"#endif\n"
"\n"
"#ifdef MODE_LIGHTSOURCE\n"
"uniform highp vec3 LightPosition;\n"
"#endif\n"
"uniform highp vec3 EyePosition;\n"
"#ifdef MODE_LIGHTDIRECTION\n"
"uniform highp vec3 LightDir;\n"
"#endif\n"
"uniform highp vec4 FogPlane;\n"
"\n"
"#ifdef USESHADOWMAPORTHO\n"
"dp_varying highp vec3 ShadowMapTC;\n"
"#endif\n"
"\n"
"#ifdef USEBOUNCEGRID\n"
"dp_varying highp vec3 BounceGridTexCoord;\n"
"#endif\n"
"\n"
"#ifdef MODE_DEFERREDGEOMETRY\n"
"dp_varying highp float Depth;\n"
"#endif\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"// TODO: get rid of tangentt (texcoord2) and use a crossproduct to regenerate it from tangents (texcoord1) and normal (texcoord3), this would require sending a 4 component texcoord1 with W as 1 or -1 according to which side the texcoord2 should be on\n"
"\n"
"// fragment shader specific:\n"
"#ifdef FRAGMENT_SHADER\n"
"\n"
"uniform sampler2D Texture_Normal;\n"
"uniform sampler2D Texture_Color;\n"
"uniform sampler2D Texture_Gloss;\n"
"#ifdef USEGLOW\n"
"uniform sampler2D Texture_Glow;\n"
"#endif\n"
"#ifdef USEVERTEXTEXTUREBLEND\n"
"uniform sampler2D Texture_SecondaryNormal;\n"
"uniform sampler2D Texture_SecondaryColor;\n"
"uniform sampler2D Texture_SecondaryGloss;\n"
"#ifdef USEGLOW\n"
"uniform sampler2D Texture_SecondaryGlow;\n"
"#endif\n"
"#endif\n"
"#ifdef USECOLORMAPPING\n"
"uniform sampler2D Texture_Pants;\n"
"uniform sampler2D Texture_Shirt;\n"
"#endif\n"
"#ifdef USEFOG\n"
"#ifdef USEFOGHEIGHTTEXTURE\n"
"uniform sampler2D Texture_FogHeightTexture;\n"
"#endif\n"
"uniform sampler2D Texture_FogMask;\n"
"#endif\n"
"#ifdef USELIGHTMAP\n"
"uniform sampler2D Texture_Lightmap;\n"
"#endif\n"
"#if defined(MODE_LIGHTDIRECTIONMAP_MODELSPACE) || defined(MODE_LIGHTDIRECTIONMAP_TANGENTSPACE)\n"
"uniform sampler2D Texture_Deluxemap;\n"
"#endif\n"
"#ifdef USEREFLECTION\n"
"uniform sampler2D Texture_Reflection;\n"
"#endif\n"
"\n"
"#ifdef MODE_DEFERREDLIGHTSOURCE\n"
"uniform sampler2D Texture_ScreenNormalMap;\n"
"#endif\n"
"#ifdef USEDEFERREDLIGHTMAP\n"
"#ifdef USECELOUTLINES\n"
"uniform sampler2D Texture_ScreenNormalMap;\n"
"#endif\n"
"uniform sampler2D Texture_ScreenDiffuse;\n"
"uniform sampler2D Texture_ScreenSpecular;\n"
"#endif\n"
"\n"
"uniform mediump vec3 Color_Pants;\n"
"uniform mediump vec3 Color_Shirt;\n"
"uniform mediump vec3 FogColor;\n"
"\n"
"#ifdef USEFOG\n"
"uniform highp float FogRangeRecip;\n"
"uniform highp float FogPlaneViewDist;\n"
"uniform highp float FogHeightFade;\n"
"vec3 FogVertex(vec4 surfacecolor)\n"
"{\n"
"#if defined(MODE_LIGHTDIRECTIONMAP_MODELSPACE) || defined(MODE_DEFERREDGEOMETRY) || defined(USEREFLECTCUBE) || defined(USEBOUNCEGRIDDIRECTIONAL)\n"
"	vec3 EyeVectorModelSpace = vec3(VectorS.w, VectorT.w, VectorR.w);\n"
"#endif\n"
"	float FogPlaneVertexDist = EyeVectorFogDepth.w;\n"
"	float fogfrac;\n"
"       vec3 fc = FogColor;\n"
"#ifdef USEFOGALPHAHACK\n"
"	fc *= surfacecolor.a;\n"
"#endif\n"
"#ifdef USEFOGHEIGHTTEXTURE\n"
"	vec4 fogheightpixel = dp_texture2D(Texture_FogHeightTexture, vec2(1,1) + vec2(FogPlaneVertexDist, FogPlaneViewDist) * (-2.0 * FogHeightFade));\n"
"	fogfrac = fogheightpixel.a;\n"
"	return mix(fogheightpixel.rgb * fc, surfacecolor.rgb, dp_texture2D(Texture_FogMask, cast_myhalf2(length(EyeVectorModelSpace)*fogfrac*FogRangeRecip, 0.0)).r);\n"
"#else\n"
"# ifdef USEFOGOUTSIDE\n"
"	fogfrac = min(0.0, FogPlaneVertexDist) / (FogPlaneVertexDist - FogPlaneViewDist) * min(1.0, min(0.0, FogPlaneVertexDist) * FogHeightFade);\n"
"# else\n"
"	fogfrac = FogPlaneViewDist / (FogPlaneViewDist - max(0.0, FogPlaneVertexDist)) * min(1.0, (min(0.0, FogPlaneVertexDist) + FogPlaneViewDist) * FogHeightFade);\n"
"# endif\n"
"	return mix(fc, surfacecolor.rgb, dp_texture2D(Texture_FogMask, cast_myhalf2(length(EyeVectorModelSpace)*fogfrac*FogRangeRecip, 0.0)).r);\n"
"#endif\n"
"}\n"
"#endif\n"
"\n"
"#ifdef USEOFFSETMAPPING\n"
"uniform mediump vec4 OffsetMapping_ScaleSteps;\n"
"uniform mediump float OffsetMapping_Bias;\n"
"#ifdef USEOFFSETMAPPING_LOD\n"
"uniform mediump float OffsetMapping_LodDistance;\n"
"#endif\n"
"vec2 OffsetMapping(vec2 TexCoord, vec2 dPdx, vec2 dPdy)\n"
"{\n"
"	float i;\n"
"	// distance-based LOD\n"
"#ifdef USEOFFSETMAPPING_LOD\n"
"	//mediump float LODFactor = min(1.0, OffsetMapping_LodDistance / EyeVectorFogDepth.z);\n"
"	//mediump vec4 ScaleSteps = vec4(OffsetMapping_ScaleSteps.x, OffsetMapping_ScaleSteps.y * LODFactor, OffsetMapping_ScaleSteps.z / LODFactor, OffsetMapping_ScaleSteps.w * LODFactor);\n"
"	mediump float GuessLODFactor = min(1.0, OffsetMapping_LodDistance / EyeVectorFogDepth.z);\n"
"#ifdef USEOFFSETMAPPING_RELIEFMAPPING\n"
"	// stupid workaround because 1-step and 2-step reliefmapping is void\n"
"	mediump float LODSteps = max(3.0, ceil(GuessLODFactor * OffsetMapping_ScaleSteps.y));\n"
"#else\n"
"	mediump float LODSteps = ceil(GuessLODFactor * OffsetMapping_ScaleSteps.y);\n"
"#endif\n"
"	mediump float LODFactor = LODSteps / OffsetMapping_ScaleSteps.y;\n"
"	mediump vec4 ScaleSteps = vec4(OffsetMapping_ScaleSteps.x, LODSteps, 1.0 / LODSteps, OffsetMapping_ScaleSteps.w * LODFactor);\n"
"#else\n"
"	#define ScaleSteps OffsetMapping_ScaleSteps\n"
"#endif\n"
"#ifdef USEOFFSETMAPPING_RELIEFMAPPING\n"
"	float f;\n"
"	// 14 sample relief mapping: linear search and then binary search\n"
"	// this basically steps forward a small amount repeatedly until it finds\n"
"	// itself inside solid, then jitters forward and back using decreasing\n"
"	// amounts to find the impact\n"
"	//vec3 OffsetVector = vec3(EyeVectorFogDepth.xy * ((1.0 / EyeVectorFogDepth.z) * ScaleSteps.x) * vec2(-1, 1), -1);\n"
"	//vec3 OffsetVector = vec3(normalize(EyeVectorFogDepth.xy) * ScaleSteps.x * vec2(-1, 1), -1);\n"
"	vec3 OffsetVector = vec3(normalize(EyeVectorFogDepth.xyz).xy * ScaleSteps.x * vec2(-1, 1), -1);\n"
"	vec3 RT = vec3(vec2(TexCoord.xy - OffsetVector.xy*OffsetMapping_Bias), 1);\n"
"	OffsetVector *= ScaleSteps.z;\n"
"	for(i = 1.0; i < ScaleSteps.y; ++i)\n"
"		RT += OffsetVector *  step(dp_textureGrad(Texture_Normal, RT.xy, dPdx, dPdy).a, RT.z);\n"
"	for(i = 0.0, f = 1.0; i < ScaleSteps.w; ++i, f *= 0.5)\n"
"		RT += OffsetVector * (step(dp_textureGrad(Texture_Normal, RT.xy, dPdx, dPdy).a, RT.z) * f - 0.5 * f);\n"
"	return RT.xy;\n"
"#else\n"
"	// 2 sample offset mapping (only 2 samples because of ATI Radeon 9500-9800/X300 limits)\n"
"	//vec2 OffsetVector = vec2(EyeVectorFogDepth.xy * ((1.0 / EyeVectorFogDepth.z) * ScaleSteps.x) * vec2(-1, 1));\n"
"	//vec2 OffsetVector = vec2(normalize(EyeVectorFogDepth.xy) * ScaleSteps.x * vec2(-1, 1));\n"
"	vec2 OffsetVector = vec2(normalize(EyeVectorFogDepth.xyz).xy * ScaleSteps.x * vec2(-1, 1));\n"
"	OffsetVector *= ScaleSteps.z;\n"
"	for(i = 0.0; i < ScaleSteps.y; ++i)\n"
"		TexCoord += OffsetVector * ((1.0 - OffsetMapping_Bias) - dp_textureGrad(Texture_Normal, TexCoord, dPdx, dPdy).a);\n"
"	return TexCoord;\n"
"#endif\n"
"}\n"
"#endif // USEOFFSETMAPPING\n"
"\n"
"#if defined(MODE_LIGHTSOURCE) || defined(MODE_DEFERREDLIGHTSOURCE)\n"
"uniform sampler2D Texture_Attenuation;\n"
"uniform samplerCube Texture_Cube;\n"
"#endif\n"
"\n"
"#if defined(MODE_LIGHTSOURCE) || defined(MODE_DEFERREDLIGHTSOURCE) || defined(USESHADOWMAPORTHO)\n"
"\n"
"#ifdef USESHADOWMAP2D\n"
"# ifdef USESHADOWSAMPLER\n"
"uniform sampler2DShadow Texture_ShadowMap2D;\n"
"# else\n"
"uniform sampler2D Texture_ShadowMap2D;\n"
"# endif\n"
"#endif\n"
"\n"
"#ifdef USESHADOWMAPVSDCT\n"
"uniform samplerCube Texture_CubeProjection;\n"
"#endif\n"
"\n"
"#if defined(USESHADOWMAP2D)\n"
"uniform mediump vec2 ShadowMap_TextureScale;\n"
"uniform mediump vec4 ShadowMap_Parameters;\n"
"#endif\n"
"\n"
"#if defined(USESHADOWMAP2D)\n"
"# ifdef USESHADOWMAPORTHO\n"
"#  define GetShadowMapTC2D(dir) (min(dir, ShadowMap_Parameters.xyz))\n"
"# else\n"
"#  ifdef USESHADOWMAPVSDCT\n"
"vec3 GetShadowMapTC2D(vec3 dir)\n"
"{\n"
"	vec3 adir = abs(dir);\n"
"	float m = max(max(adir.x, adir.y), adir.z);\n"
"	vec4 proj = dp_textureCube(Texture_CubeProjection, dir);\n"
"#ifdef USEDEPTHRGB\n"
"	return vec3(mix(dir.xy, dir.zz, proj.xy) * (ShadowMap_Parameters.x / m) +  proj.zw * ShadowMap_Parameters.z, m + 64.0 * ShadowMap_Parameters.w);\n"
"#else\n"
"	vec2 mparams = ShadowMap_Parameters.xy / m;\n"
"	return vec3(mix(dir.xy, dir.zz, proj.xy) * mparams.x + proj.zw * ShadowMap_Parameters.z, mparams.y + ShadowMap_Parameters.w);\n"
"#endif\n"
"}\n"
"#  else\n"
"vec3 GetShadowMapTC2D(vec3 dir)\n"
"{\n"
"	vec3 adir = abs(dir);\n"
"	float m; vec4 proj;\n"
"	if (adir.x > adir.y) { m = adir.x; proj = vec4(dir.zyx, 0.5); } else { m = adir.y; proj = vec4(dir.xzy, 1.5); }\n"
"	if (adir.z > m) { m = adir.z; proj = vec4(dir, 2.5); }\n"
"#ifdef USEDEPTHRGB\n"
"	return vec3(proj.xy * (ShadowMap_Parameters.x / m) + vec2(0.5,0.5) + vec2(proj.z < 0.0 ? 1.5 : 0.5, proj.w) * ShadowMap_Parameters.z, m + 64.0 * ShadowMap_Parameters.w);\n"
"#else\n"
"	vec2 mparams = ShadowMap_Parameters.xy / m;\n"
"	return vec3(proj.xy * mparams.x + vec2(proj.z < 0.0 ? 1.5 : 0.5, proj.w) * ShadowMap_Parameters.z, mparams.y + ShadowMap_Parameters.w);\n"
"#endif\n"
"}\n"
"#  endif\n"
"# endif\n"
"#endif // defined(USESHADOWMAP2D)\n"
"\n"
"# ifdef USESHADOWMAP2D\n"
"float ShadowMapCompare(vec3 dir)\n"
"{\n"
"	vec3 shadowmaptc = GetShadowMapTC2D(dir);\n"
"	float f;\n"
"\n"
"#  ifdef USEDEPTHRGB\n"
"#   ifdef USESHADOWMAPPCF\n"
"#    define texval(x, y) decodedepthmacro(dp_texture2D(Texture_ShadowMap2D, center + vec2(x, y)*ShadowMap_TextureScale))\n"
"#    if USESHADOWMAPPCF > 1\n"
"	vec2 center = shadowmaptc.xy - 0.5, offset = fract(center);\n"
"	center *= ShadowMap_TextureScale;\n"
"	vec4 row1 = step(shadowmaptc.z, vec4(texval(-1.0, -1.0), texval( 0.0, -1.0), texval( 1.0, -1.0), texval( 2.0, -1.0)));\n"
"	vec4 row2 = step(shadowmaptc.z, vec4(texval(-1.0,  0.0), texval( 0.0,  0.0), texval( 1.0,  0.0), texval( 2.0,  0.0)));\n"
"	vec4 row3 = step(shadowmaptc.z, vec4(texval(-1.0,  1.0), texval( 0.0,  1.0), texval( 1.0,  1.0), texval( 2.0,  1.0)));\n"
"	vec4 row4 = step(shadowmaptc.z, vec4(texval(-1.0,  2.0), texval( 0.0,  2.0), texval( 1.0,  2.0), texval( 2.0,  2.0)));\n"
"	vec4 cols = row2 + row3 + mix(row1, row4, offset.y);\n"
"	f = dot(mix(cols.xyz, cols.yzw, offset.x), vec3(1.0/9.0));\n"
"#    else\n"
"	vec2 center = shadowmaptc.xy*ShadowMap_TextureScale, offset = fract(shadowmaptc.xy);\n"
"	vec3 row1 = step(shadowmaptc.z, vec3(texval(-1.0, -1.0), texval( 0.0, -1.0), texval( 1.0, -1.0)));\n"
"	vec3 row2 = step(shadowmaptc.z, vec3(texval(-1.0,  0.0), texval( 0.0,  0.0), texval( 1.0,  0.0)));\n"
"	vec3 row3 = step(shadowmaptc.z, vec3(texval(-1.0,  1.0), texval( 0.0,  1.0), texval( 1.0,  1.0)));\n"
"	vec3 cols = row2 + mix(row1, row3, offset.y);\n"
"	f = dot(mix(cols.xy, cols.yz, offset.x), vec2(0.25));\n"
"#    endif\n"
"#   else\n"
"	f = step(shadowmaptc.z, decodedepthmacro(dp_texture2D(Texture_ShadowMap2D, shadowmaptc.xy*ShadowMap_TextureScale)));\n"
"#   endif\n"
"#  else\n"
"#   ifdef USESHADOWSAMPLER\n"
"#     ifdef USESHADOWMAPPCF\n"
"#       define texval(x, y) dp_shadow2D(Texture_ShadowMap2D, vec3(center + vec2(x, y)*ShadowMap_TextureScale, shadowmaptc.z))  \n"
"	vec2 center = shadowmaptc.xy*ShadowMap_TextureScale;\n"
"	f = dot(vec4(0.25), vec4(texval(-0.4, 1.0), texval(-1.0, -0.4), texval(0.4, -1.0), texval(1.0, 0.4)));\n"
"#     else\n"
"	f = dp_shadow2D(Texture_ShadowMap2D, vec3(shadowmaptc.xy*ShadowMap_TextureScale, shadowmaptc.z));\n"
"#     endif\n"
"#   else\n"
"#     ifdef USESHADOWMAPPCF\n"
"#      if defined(GL_ARB_texture_gather) || defined(GL_AMD_texture_texture4)\n"
"#       ifdef GL_ARB_texture_gather\n"
"#         define texval(x, y) textureGatherOffset(Texture_ShadowMap2D, center, ivec2(x, y))\n"
"#       else\n"
"#         define texval(x, y) texture4(Texture_ShadowMap2D, center + vec2(x, y)*ShadowMap_TextureScale)\n"
"#       endif\n"
"	vec2 offset = fract(shadowmaptc.xy - 0.5), center = (shadowmaptc.xy - offset)*ShadowMap_TextureScale;\n"
"#       if USESHADOWMAPPCF > 1\n"
"   vec4 group1 = step(shadowmaptc.z, texval(-2.0, -2.0));\n"
"   vec4 group2 = step(shadowmaptc.z, texval( 0.0, -2.0));\n"
"   vec4 group3 = step(shadowmaptc.z, texval( 2.0, -2.0));\n"
"   vec4 group4 = step(shadowmaptc.z, texval(-2.0,  0.0));\n"
"   vec4 group5 = step(shadowmaptc.z, texval( 0.0,  0.0));\n"
"   vec4 group6 = step(shadowmaptc.z, texval( 2.0,  0.0));\n"
"   vec4 group7 = step(shadowmaptc.z, texval(-2.0,  2.0));\n"
"   vec4 group8 = step(shadowmaptc.z, texval( 0.0,  2.0));\n"
"   vec4 group9 = step(shadowmaptc.z, texval( 2.0,  2.0));\n"
"	vec4 locols = vec4(group1.ab, group3.ab);\n"
"	vec4 hicols = vec4(group7.rg, group9.rg);\n"
"	locols.yz += group2.ab;\n"
"	hicols.yz += group8.rg;\n"
"	vec4 midcols = vec4(group1.rg, group3.rg) + vec4(group7.ab, group9.ab) +\n"
"				vec4(group4.rg, group6.rg) + vec4(group4.ab, group6.ab) +\n"
"				mix(locols, hicols, offset.y);\n"
"	vec4 cols = group5 + vec4(group2.rg, group8.ab);\n"
"	cols.xyz += mix(midcols.xyz, midcols.yzw, offset.x);\n"
"	f = dot(cols, vec4(1.0/25.0));\n"
"#      else\n"
"	vec4 group1 = step(shadowmaptc.z, texval(-1.0, -1.0));\n"
"	vec4 group2 = step(shadowmaptc.z, texval( 1.0, -1.0));\n"
"	vec4 group3 = step(shadowmaptc.z, texval(-1.0,  1.0));\n"
"	vec4 group4 = step(shadowmaptc.z, texval( 1.0,  1.0));\n"
"	vec4 cols = vec4(group1.rg, group2.rg) + vec4(group3.ab, group4.ab) +\n"
"				mix(vec4(group1.ab, group2.ab), vec4(group3.rg, group4.rg), offset.y);\n"
"	f = dot(mix(cols.xyz, cols.yzw, offset.x), vec3(1.0/9.0));\n"
"#       endif\n"
"#      else\n"
"#       ifdef GL_EXT_gpu_shader4\n"
"#         define texval(x, y) dp_textureOffset(Texture_ShadowMap2D, center, x, y).r\n"
"#       else\n"
"#         define texval(x, y) dp_texture2D(Texture_ShadowMap2D, center + vec2(x, y)*ShadowMap_TextureScale).r  \n"
"#       endif\n"
"#       if USESHADOWMAPPCF > 1\n"
"	vec2 center = shadowmaptc.xy - 0.5, offset = fract(center);\n"
"	center *= ShadowMap_TextureScale;\n"
"	vec4 row1 = step(shadowmaptc.z, vec4(texval(-1.0, -1.0), texval( 0.0, -1.0), texval( 1.0, -1.0), texval( 2.0, -1.0)));\n"
"	vec4 row2 = step(shadowmaptc.z, vec4(texval(-1.0,  0.0), texval( 0.0,  0.0), texval( 1.0,  0.0), texval( 2.0,  0.0)));\n"
"	vec4 row3 = step(shadowmaptc.z, vec4(texval(-1.0,  1.0), texval( 0.0,  1.0), texval( 1.0,  1.0), texval( 2.0,  1.0)));\n"
"	vec4 row4 = step(shadowmaptc.z, vec4(texval(-1.0,  2.0), texval( 0.0,  2.0), texval( 1.0,  2.0), texval( 2.0,  2.0)));\n"
"	vec4 cols = row2 + row3 + mix(row1, row4, offset.y);\n"
"	f = dot(mix(cols.xyz, cols.yzw, offset.x), vec3(1.0/9.0));\n"
"#       else\n"
"	vec2 center = shadowmaptc.xy*ShadowMap_TextureScale, offset = fract(shadowmaptc.xy);\n"
"	vec3 row1 = step(shadowmaptc.z, vec3(texval(-1.0, -1.0), texval( 0.0, -1.0), texval( 1.0, -1.0)));\n"
"	vec3 row2 = step(shadowmaptc.z, vec3(texval(-1.0,  0.0), texval( 0.0,  0.0), texval( 1.0,  0.0)));\n"
"	vec3 row3 = step(shadowmaptc.z, vec3(texval(-1.0,  1.0), texval( 0.0,  1.0), texval( 1.0,  1.0)));\n"
"	vec3 cols = row2 + mix(row1, row3, offset.y);\n"
"	f = dot(mix(cols.xy, cols.yz, offset.x), vec2(0.25));\n"
"#       endif\n"
"#      endif\n"
"#     else\n"
"	f = step(shadowmaptc.z, dp_texture2D(Texture_ShadowMap2D, shadowmaptc.xy*ShadowMap_TextureScale).r);\n"
"#     endif\n"
"#   endif\n"
"#  endif\n"
"#  ifdef USESHADOWMAPORTHO\n"
"	return mix(ShadowMap_Parameters.w, 1.0, f);\n"
"#  else\n"
"	return f;\n"
"#  endif\n"
"}\n"
"# endif\n"
"#endif // !defined(MODE_LIGHTSOURCE) && !defined(MODE_DEFERREDLIGHTSOURCE) && !defined(USESHADOWMAPORTHO)\n"
"#endif // FRAGMENT_SHADER\n"
"\n"
"\n"
"\n"
"\n"
"#ifdef MODE_DEFERREDGEOMETRY\n"
"#ifdef VERTEX_SHADER\n"
"uniform highp mat4 TexMatrix;\n"
"#ifdef USEVERTEXTEXTUREBLEND\n"
"uniform highp mat4 BackgroundTexMatrix;\n"
"#endif\n"
"uniform highp mat4 ModelViewMatrix;\n"
"void main(void)\n"
"{\n"
"	TexCoordSurfaceLightmap = vec4((TexMatrix * Attrib_TexCoord0).xy, 0.0, 0.0);\n"
"#ifdef USEVERTEXTEXTUREBLEND\n"
"	VertexColor = Attrib_Color;\n"
"	TexCoord2 = vec2(BackgroundTexMatrix * Attrib_TexCoord0);\n"
"#endif\n"
"\n"
"	// transform unnormalized eye direction into tangent space\n"
"#ifdef USEOFFSETMAPPING\n"
"	vec3 EyeRelative = EyePosition - Attrib_Position.xyz;\n"
"	EyeVectorFogDepth.x = dot(EyeRelative, Attrib_TexCoord1.xyz);\n"
"	EyeVectorFogDepth.y = dot(EyeRelative, Attrib_TexCoord2.xyz);\n"
"	EyeVectorFogDepth.z = dot(EyeRelative, Attrib_TexCoord3.xyz);\n"
"	EyeVectorFogDepth.w = 0.0;\n"
"#endif\n"
"\n"
"	VectorS = (ModelViewMatrix * vec4(Attrib_TexCoord1.xyz, 0));\n"
"	VectorT = (ModelViewMatrix * vec4(Attrib_TexCoord2.xyz, 0));\n"
"	VectorR = (ModelViewMatrix * vec4(Attrib_TexCoord3.xyz, 0));\n"
"	gl_Position = ModelViewProjectionMatrix * Attrib_Position;\n"
"#ifdef USETRIPPY\n"
"	gl_Position = TrippyVertex(gl_Position);\n"
"#endif\n"
"	Depth = (ModelViewMatrix * Attrib_Position).z;\n"
"}\n"
"#endif // VERTEX_SHADER\n"
"\n"
"#ifdef FRAGMENT_SHADER\n"
"void main(void)\n"
"{\n"
"#ifdef USEOFFSETMAPPING\n"
"	// apply offsetmapping\n"
"	vec2 dPdx = dp_offsetmapping_dFdx(TexCoordSurfaceLightmap.xy);\n"
"	vec2 dPdy = dp_offsetmapping_dFdy(TexCoordSurfaceLightmap.xy);\n"
"	vec2 TexCoordOffset = OffsetMapping(TexCoordSurfaceLightmap.xy, dPdx, dPdy);\n"
"# define offsetMappedTexture2D(t) dp_textureGrad(t, TexCoordOffset, dPdx, dPdy)\n"
"#else\n"
"# define offsetMappedTexture2D(t) dp_texture2D(t, TexCoordSurfaceLightmap.xy)\n"
"#endif\n"
"\n"
"#ifdef USEALPHAKILL\n"
"	if (offsetMappedTexture2D(Texture_Color).a < 0.5)\n"
"		discard;\n"
"#endif\n"
"\n"
"#ifdef USEVERTEXTEXTUREBLEND\n"
"	float alpha = offsetMappedTexture2D(Texture_Color).a;\n"
"	float terrainblend = clamp(float(VertexColor.a) * alpha * 2.0 - 0.5, float(0.0), float(1.0));\n"
"	//float terrainblend = min(float(VertexColor.a) * alpha * 2.0, float(1.0));\n"
"	//float terrainblend = float(VertexColor.a) * alpha > 0.5;\n"
"#endif\n"
"\n"
"#ifdef USEVERTEXTEXTUREBLEND\n"
"	vec3 surfacenormal = mix(vec3(dp_texture2D(Texture_SecondaryNormal, TexCoord2)), vec3(offsetMappedTexture2D(Texture_Normal)), terrainblend) - vec3(0.5, 0.5, 0.5);\n"
"	float a = mix(dp_texture2D(Texture_SecondaryGloss, TexCoord2).a, offsetMappedTexture2D(Texture_Gloss).a, terrainblend);\n"
"#else\n"
"	vec3 surfacenormal = vec3(offsetMappedTexture2D(Texture_Normal)) - vec3(0.5, 0.5, 0.5);\n"
"	float a = offsetMappedTexture2D(Texture_Gloss).a;\n"
"#endif\n"
"\n"
"	vec3 pixelnormal = normalize(surfacenormal.x * VectorS.xyz + surfacenormal.y * VectorT.xyz + surfacenormal.z * VectorR.xyz);\n"
"	dp_FragColor = vec4(pixelnormal.x, pixelnormal.y, Depth, a);\n"
"}\n"
"#endif // FRAGMENT_SHADER\n"
"#else // !MODE_DEFERREDGEOMETRY\n"
"\n"
"\n"
"\n"
"\n"
"#ifdef MODE_DEFERREDLIGHTSOURCE\n"
"#ifdef VERTEX_SHADER\n"
"uniform highp mat4 ModelViewMatrix;\n"
"void main(void)\n"
"{\n"
"	ModelViewPosition = ModelViewMatrix * Attrib_Position;\n"
"	gl_Position = ModelViewProjectionMatrix * Attrib_Position;\n"
"}\n"
"#endif // VERTEX_SHADER\n"
"\n"
"#ifdef FRAGMENT_SHADER\n"
"uniform highp mat4 ViewToLight;\n"
"// ScreenToDepth = vec2(Far / (Far - Near), Far * Near / (Near - Far));\n"
"uniform highp vec2 ScreenToDepth;\n"
"uniform myhalf3 DeferredColor_Ambient;\n"
"uniform myhalf3 DeferredColor_Diffuse;\n"
"#ifdef USESPECULAR\n"
"uniform myhalf3 DeferredColor_Specular;\n"
"uniform myhalf SpecularPower;\n"
"#endif\n"
"uniform myhalf2 PixelToScreenTexCoord;\n"
"void main(void)\n"
"{\n"
"	// calculate viewspace pixel position\n"
"	vec2 ScreenTexCoord = gl_FragCoord.xy * PixelToScreenTexCoord;\n"
"	vec3 position;\n"
"	// get the geometry information (depth, normal, specular exponent)\n"
"	myhalf4 normalmap = dp_texture2D(Texture_ScreenNormalMap, ScreenTexCoord);\n"
"	// decode viewspace pixel normal\n"
"//	myhalf3 surfacenormal = normalize(normalmap.rgb - cast_myhalf3(0.5,0.5,0.5));\n"
"	myhalf3 surfacenormal = myhalf3(normalmap.rg, sqrt(1.0-dot(normalmap.rg, normalmap.rg)));\n"
"	// decode viewspace pixel position\n"
"//	position.z = decodedepthmacro(dp_texture2D(Texture_ScreenDepth, ScreenTexCoord));\n"
"	position.z = normalmap.b;\n"
"//	position.z = ScreenToDepth.y / (dp_texture2D(Texture_ScreenDepth, ScreenTexCoord).r + ScreenToDepth.x);\n"
"	position.xy = ModelViewPosition.xy * (position.z / ModelViewPosition.z);\n"
"\n"
"	// now do the actual shading\n"
"	// surfacenormal = pixel normal in viewspace\n"
"	// LightVector = pixel to light in viewspace\n"
"	// CubeVector = pixel in lightspace\n"
"	// eyenormal = pixel to view direction in viewspace\n"
"	vec3 CubeVector = vec3(ViewToLight * vec4(position,1));\n"
"	myhalf fade = cast_myhalf(dp_texture2D(Texture_Attenuation, vec2(length(CubeVector), 0.0)));\n"
"#ifdef USEDIFFUSE\n"
"	// calculate diffuse shading\n"
"	myhalf3 lightnormal = cast_myhalf3(normalize(LightPosition - position));\n"
"SHADEDIFFUSE\n"
"#endif\n"
"#ifdef USESPECULAR\n"
"	// calculate directional shading\n"
"	myhalf3 eyenormal = -normalize(cast_myhalf3(position));\n"
"SHADESPECULAR(SpecularPower * normalmap.a)\n"
"#endif\n"
"\n"
"#if defined(USESHADOWMAP2D)\n"
"	fade *= ShadowMapCompare(CubeVector);\n"
"#endif\n"
"\n"
"#ifdef USESPECULAR\n"
"	gl_FragData[0] = vec4((DeferredColor_Ambient + DeferredColor_Diffuse * diffuse) * fade, 1.0);\n"
"	gl_FragData[1] = vec4(DeferredColor_Specular * (specular * fade), 1.0);\n"
"# ifdef USECUBEFILTER\n"
"	vec3 cubecolor = dp_textureCube(Texture_Cube, CubeVector).rgb;\n"
"	gl_FragData[0].rgb *= cubecolor;\n"
"	gl_FragData[1].rgb *= cubecolor;\n"
"# endif\n"
"#else\n"
"# ifdef USEDIFFUSE\n"
"	gl_FragColor = vec4((DeferredColor_Ambient + DeferredColor_Diffuse * diffuse) * fade, 1.0);\n"
"# else\n"
"	gl_FragColor = vec4(DeferredColor_Ambient * fade, 1.0);\n"
"# endif\n"
"# ifdef USECUBEFILTER\n"
"	vec3 cubecolor = dp_textureCube(Texture_Cube, CubeVector).rgb;\n"
"	gl_FragColor.rgb *= cubecolor;\n"
"# endif\n"
"#endif\n"
"}\n"
"#endif // FRAGMENT_SHADER\n"
"#else // !MODE_DEFERREDLIGHTSOURCE\n"
"\n"
"\n"
"\n"
"\n"
"#ifdef VERTEX_SHADER\n"
"uniform highp mat4 TexMatrix;\n"
"#ifdef USEVERTEXTEXTUREBLEND\n"
"uniform highp mat4 BackgroundTexMatrix;\n"
"#endif\n"
"#ifdef MODE_LIGHTSOURCE\n"
"uniform highp mat4 ModelToLight;\n"
"#endif\n"
"#ifdef USESHADOWMAPORTHO\n"
"uniform highp mat4 ShadowMapMatrix;\n"
"#endif\n"
"#ifdef USEBOUNCEGRID\n"
"uniform highp mat4 BounceGridMatrix;\n"
"#endif\n"
"void main(void)\n"
"{\n"
"#if defined(MODE_VERTEXCOLOR) || defined(USEVERTEXTEXTUREBLEND) || defined(MODE_LIGHTDIRECTIONMAP_FORCED_VERTEXCOLOR) || defined(USEALPHAGENVERTEX)\n"
"	VertexColor = Attrib_Color;\n"
"#endif\n"
"	// copy the surface texcoord\n"
"#ifdef USELIGHTMAP\n"
"	TexCoordSurfaceLightmap = vec4((TexMatrix * Attrib_TexCoord0).xy, Attrib_TexCoord4.xy);\n"
"#else\n"
"	TexCoordSurfaceLightmap = vec4((TexMatrix * Attrib_TexCoord0).xy, 0.0, 0.0);\n"
"#endif\n"
"#ifdef USEVERTEXTEXTUREBLEND\n"
"	TexCoord2 = vec2(BackgroundTexMatrix * Attrib_TexCoord0);\n"
"#endif\n"
"\n"
"#ifdef USEBOUNCEGRID\n"
"	BounceGridTexCoord = vec3(BounceGridMatrix * Attrib_Position);\n"
"#ifdef USEBOUNCEGRIDDIRECTIONAL\n"
"	BounceGridTexCoord.z *= 0.125;\n"
"#endif\n"
"#endif\n"
"\n"
"#ifdef MODE_LIGHTSOURCE\n"
"	// transform vertex position into light attenuation/cubemap space\n"
"	// (-1 to +1 across the light box)\n"
"	CubeVector = vec3(ModelToLight * Attrib_Position);\n"
"\n"
"# ifdef USEDIFFUSE\n"
"	// transform unnormalized light direction into tangent space\n"
"	// (we use unnormalized to ensure that it interpolates correctly and then\n"
"	//  normalize it per pixel)\n"
"	vec3 lightminusvertex = LightPosition - Attrib_Position.xyz;\n"
"	LightVector.x = dot(lightminusvertex, Attrib_TexCoord1.xyz);\n"
"	LightVector.y = dot(lightminusvertex, Attrib_TexCoord2.xyz);\n"
"	LightVector.z = dot(lightminusvertex, Attrib_TexCoord3.xyz);\n"
"# endif\n"
"#endif\n"
"\n"
"#if defined(MODE_LIGHTDIRECTION) && defined(USEDIFFUSE)\n"
"	LightVector.x = dot(LightDir, Attrib_TexCoord1.xyz);\n"
"	LightVector.y = dot(LightDir, Attrib_TexCoord2.xyz);\n"
"	LightVector.z = dot(LightDir, Attrib_TexCoord3.xyz);\n"
"#endif\n"
"\n"
"	// transform unnormalized eye direction into tangent space\n"
"#ifdef USEEYEVECTOR\n"
"	vec3 EyeRelative = EyePosition - Attrib_Position.xyz;\n"
"	EyeVectorFogDepth.x = dot(EyeRelative, Attrib_TexCoord1.xyz);\n"
"	EyeVectorFogDepth.y = dot(EyeRelative, Attrib_TexCoord2.xyz);\n"
"	EyeVectorFogDepth.z = dot(EyeRelative, Attrib_TexCoord3.xyz);\n"
"#ifdef USEFOG\n"
"	EyeVectorFogDepth.w = dot(FogPlane, Attrib_Position);\n"
"#else\n"
"	EyeVectorFogDepth.w = 0.0;\n"
"#endif\n"
"#endif\n"
"\n"
"\n"
"#if defined(MODE_LIGHTDIRECTIONMAP_MODELSPACE) || defined(USEREFLECTCUBE) || defined(USEBOUNCEGRIDDIRECTIONAL)\n"
"# ifdef USEFOG\n"
"	VectorS = vec4(Attrib_TexCoord1.xyz, EyePosition.x - Attrib_Position.x);\n"
"	VectorT = vec4(Attrib_TexCoord2.xyz, EyePosition.y - Attrib_Position.y);\n"
"	VectorR = vec4(Attrib_TexCoord3.xyz, EyePosition.z - Attrib_Position.z);\n"
"# else\n"
"	VectorS = vec4(Attrib_TexCoord1, 0);\n"
"	VectorT = vec4(Attrib_TexCoord2, 0);\n"
"	VectorR = vec4(Attrib_TexCoord3, 0);\n"
"# endif\n"
"#else\n"
"# ifdef USEFOG\n"
"	EyeVectorModelSpace = EyePosition - Attrib_Position.xyz;\n"
"# endif\n"
"#endif\n"
"\n"
"	// transform vertex to clipspace (post-projection, but before perspective divide by W occurs)\n"
"	gl_Position = ModelViewProjectionMatrix * Attrib_Position;\n"
"\n"
"#ifdef USESHADOWMAPORTHO\n"
"	ShadowMapTC = vec3(ShadowMapMatrix * gl_Position);\n"
"#endif\n"
"\n"
"#ifdef USEREFLECTION\n"
"	ModelViewProjectionPosition = gl_Position;\n"
"#endif\n"
"#ifdef USETRIPPY\n"
"	gl_Position = TrippyVertex(gl_Position);\n"
"#endif\n"
"}\n"
"#endif // VERTEX_SHADER\n"
"\n"
"\n"
"\n"
"\n"
"#ifdef FRAGMENT_SHADER\n"
"#ifdef USEDEFERREDLIGHTMAP\n"
"uniform myhalf2 PixelToScreenTexCoord;\n"
"uniform myhalf3 DeferredMod_Diffuse;\n"
"uniform myhalf3 DeferredMod_Specular;\n"
"#endif\n"
"uniform myhalf3 Color_Ambient;\n"
"uniform myhalf3 Color_Diffuse;\n"
"uniform myhalf3 Color_Specular;\n"
"uniform myhalf SpecularPower;\n"
"#ifdef USEGLOW\n"
"uniform myhalf3 Color_Glow;\n"
"#endif\n"
"uniform myhalf Alpha;\n"
"#ifdef USEREFLECTION\n"
"uniform mediump vec4 DistortScaleRefractReflect;\n"
"uniform mediump vec4 ScreenScaleRefractReflect;\n"
"uniform mediump vec4 ScreenCenterRefractReflect;\n"
"uniform mediump vec4 ReflectColor;\n"
"#endif\n"
"#ifdef USEREFLECTCUBE\n"
"uniform highp mat4 ModelToReflectCube;\n"
"uniform sampler2D Texture_ReflectMask;\n"
"uniform samplerCube Texture_ReflectCube;\n"
"#endif\n"
"#ifdef MODE_LIGHTDIRECTION\n"
"uniform myhalf3 LightColor;\n"
"#endif\n"
"#ifdef MODE_LIGHTSOURCE\n"
"uniform myhalf3 LightColor;\n"
"#endif\n"
"#ifdef USEBOUNCEGRID\n"
"uniform sampler3D Texture_BounceGrid;\n"
"uniform float BounceGridIntensity;\n"
"uniform highp mat4 BounceGridMatrix;\n"
"#endif\n"
"uniform highp float ClientTime;\n"
"#ifdef USENORMALMAPSCROLLBLEND\n"
"uniform highp vec2 NormalmapScrollBlend;\n"
"#endif\n"
"void main(void)\n"
"{\n"
"#ifdef USEOFFSETMAPPING\n"
"	// apply offsetmapping\n"
"	vec2 dPdx = dp_offsetmapping_dFdx(TexCoordSurfaceLightmap.xy);\n"
"	vec2 dPdy = dp_offsetmapping_dFdy(TexCoordSurfaceLightmap.xy);\n"
"	vec2 TexCoordOffset = OffsetMapping(TexCoordSurfaceLightmap.xy, dPdx, dPdy);\n"
"# define offsetMappedTexture2D(t) dp_textureGrad(t, TexCoordOffset, dPdx, dPdy)\n"
"# define TexCoord TexCoordOffset\n"
"#else\n"
"# define offsetMappedTexture2D(t) dp_texture2D(t, TexCoordSurfaceLightmap.xy)\n"
"# define TexCoord TexCoordSurfaceLightmap.xy\n"
"#endif\n"
"\n"
"	// combine the diffuse textures (base, pants, shirt)\n"
"	myhalf4 color = cast_myhalf4(offsetMappedTexture2D(Texture_Color));\n"
"#ifdef USEALPHAKILL\n"
"	if (color.a < 0.5)\n"
"		discard;\n"
"#endif\n"
"	color.a *= Alpha;\n"
"#ifdef USECOLORMAPPING\n"
"	color.rgb += cast_myhalf3(offsetMappedTexture2D(Texture_Pants)) * Color_Pants + cast_myhalf3(offsetMappedTexture2D(Texture_Shirt)) * Color_Shirt;\n"
"#endif\n"
"#ifdef USEVERTEXTEXTUREBLEND\n"
"#ifdef USEBOTHALPHAS\n"
"	myhalf4 color2 = cast_myhalf4(dp_texture2D(Texture_SecondaryColor, TexCoord2));\n"
"	myhalf terrainblend = clamp(cast_myhalf(VertexColor.a) * color.a, cast_myhalf(1.0 - color2.a), cast_myhalf(1.0));\n"
"	color.rgb = mix(color2.rgb, color.rgb, terrainblend);\n"
"#else\n"
"	myhalf terrainblend = clamp(cast_myhalf(VertexColor.a) * color.a * 2.0 - 0.5, cast_myhalf(0.0), cast_myhalf(1.0));\n"
"	//myhalf terrainblend = min(cast_myhalf(VertexColor.a) * color.a * 2.0, cast_myhalf(1.0));\n"
"	//myhalf terrainblend = cast_myhalf(VertexColor.a) * color.a > 0.5;\n"
"	color.rgb = mix(cast_myhalf3(dp_texture2D(Texture_SecondaryColor, TexCoord2)), color.rgb, terrainblend);\n"
"#endif\n"
"	color.a = 1.0;\n"
"	//color = mix(cast_myhalf4(1, 0, 0, 1), color, terrainblend);\n"
"#endif\n"
"#ifdef USEALPHAGENVERTEX\n"
"	color.a *= VertexColor.a;\n"
"#endif\n"
"\n"
"	// get the surface normal\n"
"#ifdef USEVERTEXTEXTUREBLEND\n"
"	myhalf3 surfacenormal = normalize(mix(cast_myhalf3(dp_texture2D(Texture_SecondaryNormal, TexCoord2)), cast_myhalf3(offsetMappedTexture2D(Texture_Normal)), terrainblend) - cast_myhalf3(0.5, 0.5, 0.5));\n"
"#else\n"
"	myhalf3 surfacenormal = normalize(cast_myhalf3(offsetMappedTexture2D(Texture_Normal)) - cast_myhalf3(0.5, 0.5, 0.5));\n"
"#endif\n"
"\n"
"	// get the material colors\n"
"	myhalf3 diffusetex = color.rgb;\n"
"#if defined(USESPECULAR) || defined(USEDEFERREDLIGHTMAP)\n"
"# ifdef USEVERTEXTEXTUREBLEND\n"
"	myhalf4 glosstex = mix(cast_myhalf4(dp_texture2D(Texture_SecondaryGloss, TexCoord2)), cast_myhalf4(offsetMappedTexture2D(Texture_Gloss)), terrainblend);\n"
"# else\n"
"	myhalf4 glosstex = cast_myhalf4(offsetMappedTexture2D(Texture_Gloss));\n"
"# endif\n"
"#endif\n"
"\n"
"#ifdef USEREFLECTCUBE\n"
"	vec3 TangentReflectVector = reflect(-EyeVectorFogDepth.xyz, surfacenormal);\n"
"	vec3 ModelReflectVector = TangentReflectVector.x * VectorS.xyz + TangentReflectVector.y * VectorT.xyz + TangentReflectVector.z * VectorR.xyz;\n"
"	vec3 ReflectCubeTexCoord = vec3(ModelToReflectCube * vec4(ModelReflectVector, 0));\n"
"	diffusetex += cast_myhalf3(offsetMappedTexture2D(Texture_ReflectMask)) * cast_myhalf3(dp_textureCube(Texture_ReflectCube, ReflectCubeTexCoord));\n"
"#endif\n"
"\n"
"#ifdef USESPECULAR\n"
"	myhalf3 eyenormal = normalize(cast_myhalf3(EyeVectorFogDepth.xyz));\n"
"#endif\n"
"\n"
"\n"
"\n"
"\n"
"#ifdef MODE_LIGHTSOURCE\n"
"	// light source\n"
"#ifdef USEDIFFUSE\n"
"	myhalf3 lightnormal = cast_myhalf3(normalize(LightVector));\n"
"SHADEDIFFUSE\n"
"	color.rgb = diffusetex * (Color_Ambient + diffuse * Color_Diffuse);\n"
"#ifdef USESPECULAR\n"
"SHADESPECULAR(SpecularPower * glosstex.a)\n"
"	color.rgb += glosstex.rgb * (specular * Color_Specular);\n"
"#endif\n"
"#else\n"
"	color.rgb = diffusetex * Color_Ambient;\n"
"#endif\n"
"	color.rgb *= LightColor;\n"
"	color.rgb *= cast_myhalf(dp_texture2D(Texture_Attenuation, vec2(length(CubeVector), 0.0)));\n"
"#if defined(USESHADOWMAP2D)\n"
"	color.rgb *= ShadowMapCompare(CubeVector);\n"
"#endif\n"
"# ifdef USECUBEFILTER\n"
"	color.rgb *= cast_myhalf3(dp_textureCube(Texture_Cube, CubeVector));\n"
"# endif\n"
"#endif // MODE_LIGHTSOURCE\n"
"\n"
"\n"
"\n"
"\n"
"#ifdef MODE_LIGHTDIRECTION\n"
"	#define SHADING\n"
"	#ifdef USEDIFFUSE\n"
"		myhalf3 lightnormal = cast_myhalf3(normalize(LightVector));\n"
"	#endif\n"
"	#define lightcolor LightColor\n"
"#endif // MODE_LIGHTDIRECTION\n"
"#ifdef MODE_LIGHTDIRECTIONMAP_MODELSPACE\n"
"   #define SHADING\n"
"	// deluxemap lightmapping using light vectors in modelspace (q3map2 -light -deluxe)\n"
"	myhalf3 lightnormal_modelspace = cast_myhalf3(dp_texture2D(Texture_Deluxemap, TexCoordSurfaceLightmap.zw)) * 2.0 + cast_myhalf3(-1.0, -1.0, -1.0);\n"
"	myhalf3 lightcolor = cast_myhalf3(dp_texture2D(Texture_Lightmap, TexCoordSurfaceLightmap.zw));\n"
"	// convert modelspace light vector to tangentspace\n"
"	myhalf3 lightnormal;\n"
"	lightnormal.x = dot(lightnormal_modelspace, cast_myhalf3(VectorS));\n"
"	lightnormal.y = dot(lightnormal_modelspace, cast_myhalf3(VectorT));\n"
"	lightnormal.z = dot(lightnormal_modelspace, cast_myhalf3(VectorR));\n"
"	lightnormal = normalize(lightnormal); // VectorS/T/R are not always perfectly normalized, and EXACTSPECULARMATH is very picky about this\n"
"	// calculate directional shading (and undoing the existing angle attenuation on the lightmap by the division)\n"
"	// note that q3map2 is too stupid to calculate proper surface normals when q3map_nonplanar\n"
"	// is used (the lightmap and deluxemap coords correspond to virtually random coordinates\n"
"	// on that luxel, and NOT to its center, because recursive triangle subdivision is used\n"
"	// to map the luxels to coordinates on the draw surfaces), which also causes\n"
"	// deluxemaps to be wrong because light contributions from the wrong side of the surface\n"
"	// are added up. To prevent divisions by zero or strong exaggerations, a max()\n"
"	// nudge is done here at expense of some additional fps. This is ONLY needed for\n"
"	// deluxemaps, tangentspace deluxemap avoid this problem by design.\n"
"	lightcolor *= 1.0 / max(0.25, lightnormal.z);\n"
"#endif // MODE_LIGHTDIRECTIONMAP_MODELSPACE\n"
"#ifdef MODE_LIGHTDIRECTIONMAP_TANGENTSPACE\n"
"   #define SHADING\n"
"	// deluxemap lightmapping using light vectors in tangentspace (hmap2 -light)\n"
"	myhalf3 lightnormal = cast_myhalf3(dp_texture2D(Texture_Deluxemap, TexCoordSurfaceLightmap.zw)) * 2.0 + cast_myhalf3(-1.0, -1.0, -1.0);\n"
"	myhalf3 lightcolor = cast_myhalf3(dp_texture2D(Texture_Lightmap, TexCoordSurfaceLightmap.zw));\n"
"#endif\n"
"#if defined(MODE_LIGHTDIRECTIONMAP_FORCED_LIGHTMAP) || defined(MODE_LIGHTDIRECTIONMAP_FORCED_VERTEXCOLOR)\n"
"	#define SHADING\n"
"	// forced deluxemap on lightmapped/vertexlit surfaces\n"
"	myhalf3 lightnormal = cast_myhalf3(0.0, 0.0, 1.0);\n"
"   #ifdef USELIGHTMAP\n"
"		myhalf3 lightcolor = cast_myhalf3(dp_texture2D(Texture_Lightmap, TexCoordSurfaceLightmap.zw));\n"
"   #else\n"
"		myhalf3 lightcolor = cast_myhalf3(VertexColor.rgb);\n"
"   #endif\n"
"#endif\n"
"#ifdef MODE_FAKELIGHT\n"
"	#define SHADING\n"
"	myhalf3 lightnormal = cast_myhalf3(normalize(EyeVectorFogDepth.xyz));\n"
"	myhalf3 lightcolor = cast_myhalf3(1.0);\n"
"#endif // MODE_FAKELIGHT\n"
"\n"
"\n"
"\n"
"\n"
"#ifdef MODE_LIGHTMAP\n"
"	color.rgb = diffusetex * (Color_Ambient + cast_myhalf3(dp_texture2D(Texture_Lightmap, TexCoordSurfaceLightmap.zw)) * Color_Diffuse);\n"
"#endif // MODE_LIGHTMAP\n"
"#ifdef MODE_VERTEXCOLOR\n"
"	color.rgb = diffusetex * (Color_Ambient + cast_myhalf3(VertexColor.rgb) * Color_Diffuse);\n"
"#endif // MODE_VERTEXCOLOR\n"
"#ifdef MODE_FLATCOLOR\n"
"	color.rgb = diffusetex * Color_Ambient;\n"
"#endif // MODE_FLATCOLOR\n"
"\n"
"\n"
"\n"
"\n"
"#ifdef SHADING\n"
"# ifdef USEDIFFUSE\n"
"SHADEDIFFUSE\n"
"#  ifdef USESPECULAR\n"
"SHADESPECULAR(SpecularPower * glosstex.a)\n"
"	color.rgb = diffusetex * Color_Ambient + (diffusetex * Color_Diffuse * diffuse + glosstex.rgb * Color_Specular * specular) * lightcolor;\n"
"#  else\n"
"	color.rgb = diffusetex * (Color_Ambient + Color_Diffuse * diffuse * lightcolor);\n"
"#  endif\n"
"# else\n"
"	color.rgb = diffusetex * Color_Ambient;\n"
"# endif\n"
"#endif\n"
"\n"
"#ifdef USESHADOWMAPORTHO\n"
"	color.rgb *= ShadowMapCompare(ShadowMapTC);\n"
"#endif\n"
"\n"
"#ifdef USEDEFERREDLIGHTMAP\n"
"	vec2 ScreenTexCoord = gl_FragCoord.xy * PixelToScreenTexCoord;\n"
"	color.rgb += diffusetex * cast_myhalf3(dp_texture2D(Texture_ScreenDiffuse, ScreenTexCoord)) * DeferredMod_Diffuse;\n"
"	color.rgb += glosstex.rgb * cast_myhalf3(dp_texture2D(Texture_ScreenSpecular, ScreenTexCoord)) * DeferredMod_Specular;\n"
"//	color.rgb = dp_texture2D(Texture_ScreenNormalMap, ScreenTexCoord).rgb * vec3(1.0, 1.0, 0.001);\n"
"#endif\n"
"\n"
"#ifdef USEBOUNCEGRID\n"
"#ifdef USEBOUNCEGRIDDIRECTIONAL\n"
"//	myhalf4 bouncegrid_coeff1 = cast_myhalf4(dp_texture3D(Texture_BounceGrid, BounceGridTexCoord                        ));\n"
"//	myhalf4 bouncegrid_coeff2 = cast_myhalf4(dp_texture3D(Texture_BounceGrid, BounceGridTexCoord + vec3(0.0, 0.0, 0.125))) * 2.0 + cast_myhalf4(-1.0, -1.0, -1.0, -1.0);\n"
"	myhalf4 bouncegrid_coeff3 = cast_myhalf4(dp_texture3D(Texture_BounceGrid, BounceGridTexCoord + vec3(0.0, 0.0, 0.250)));\n"
"	myhalf4 bouncegrid_coeff4 = cast_myhalf4(dp_texture3D(Texture_BounceGrid, BounceGridTexCoord + vec3(0.0, 0.0, 0.375)));\n"
"	myhalf4 bouncegrid_coeff5 = cast_myhalf4(dp_texture3D(Texture_BounceGrid, BounceGridTexCoord + vec3(0.0, 0.0, 0.500)));\n"
"	myhalf4 bouncegrid_coeff6 = cast_myhalf4(dp_texture3D(Texture_BounceGrid, BounceGridTexCoord + vec3(0.0, 0.0, 0.625)));\n"
"	myhalf4 bouncegrid_coeff7 = cast_myhalf4(dp_texture3D(Texture_BounceGrid, BounceGridTexCoord + vec3(0.0, 0.0, 0.750)));\n"
"	myhalf4 bouncegrid_coeff8 = cast_myhalf4(dp_texture3D(Texture_BounceGrid, BounceGridTexCoord + vec3(0.0, 0.0, 0.875)));\n"
"	myhalf3 bouncegrid_dir = normalize(mat3(BounceGridMatrix) * (surfacenormal.x * VectorS.xyz + surfacenormal.y * VectorT.xyz + surfacenormal.z * VectorR.xyz));\n"
"	myhalf3 bouncegrid_dirp = max(cast_myhalf3(0.0, 0.0, 0.0), bouncegrid_dir);\n"
"	myhalf3 bouncegrid_dirn = max(cast_myhalf3(0.0, 0.0, 0.0), -bouncegrid_dir);\n"
"//	bouncegrid_dirp  = bouncegrid_dirn = cast_myhalf3(1.0,1.0,1.0);\n"
"	myhalf3 bouncegrid_light = cast_myhalf3(\n"
"		dot(bouncegrid_coeff3.xyz, bouncegrid_dirp) + dot(bouncegrid_coeff6.xyz, bouncegrid_dirn),\n"
"		dot(bouncegrid_coeff4.xyz, bouncegrid_dirp) + dot(bouncegrid_coeff7.xyz, bouncegrid_dirn),\n"
"		dot(bouncegrid_coeff5.xyz, bouncegrid_dirp) + dot(bouncegrid_coeff8.xyz, bouncegrid_dirn));\n"
"	color.rgb += diffusetex * bouncegrid_light * BounceGridIntensity;\n"
"//	color.rgb = bouncegrid_dir.rgb * 0.5 + vec3(0.5, 0.5, 0.5);\n"
"#else\n"
"	color.rgb += diffusetex * cast_myhalf3(dp_texture3D(Texture_BounceGrid, BounceGridTexCoord)) * BounceGridIntensity;\n"
"#endif\n"
"#endif\n"
"\n"
"#ifdef USEGLOW\n"
"#ifdef USEVERTEXTEXTUREBLEND\n"
"	color.rgb += mix(cast_myhalf3(dp_texture2D(Texture_SecondaryGlow, TexCoord2)), cast_myhalf3(offsetMappedTexture2D(Texture_Glow)), terrainblend) * Color_Glow;\n"
"#else\n"
"	color.rgb += cast_myhalf3(offsetMappedTexture2D(Texture_Glow)) * Color_Glow;\n"
"#endif\n"
"#endif\n"
"\n"
"#ifdef USECELOUTLINES\n"
"# ifdef USEDEFERREDLIGHTMAP\n"
"//	vec2 ScreenTexCoord = gl_FragCoord.xy * PixelToScreenTexCoord;\n"
"	vec4 ScreenTexCoordStep = vec4(PixelToScreenTexCoord.x, 0.0, 0.0, PixelToScreenTexCoord.y);\n"
"	vec4 DepthNeighbors;\n"
"	float DepthCenter = dp_texture2D(Texture_ScreenNormalMap, ScreenTexCoord).b;\n"
"	DepthNeighbors.x = dp_texture2D(Texture_ScreenNormalMap, ScreenTexCoord - ScreenTexCoordStep.xy).b;\n"
"	DepthNeighbors.y = dp_texture2D(Texture_ScreenNormalMap, ScreenTexCoord + ScreenTexCoordStep.xy).b;\n"
"	DepthNeighbors.z = dp_texture2D(Texture_ScreenNormalMap, ScreenTexCoord + ScreenTexCoordStep.zw).b;\n"
"	DepthNeighbors.w = dp_texture2D(Texture_ScreenNormalMap, ScreenTexCoord - ScreenTexCoordStep.zw).b;\n"
"	float DepthAverage = dot(DepthNeighbors, vec4(0.25, 0.25, 0.25, 0.25));\n"
"	float DepthDelta = abs(dot(DepthNeighbors.xy, vec2(-1.0, 1.0))) + abs(dot(DepthNeighbors.zw, vec2(-1.0, 1.0)));\n"
"//	color.rgb = vec3(1.0, 1.0, 1.0);\n"
"	color.rgb *= max(0.25, 1.0 - max(0.0, abs(DepthCenter - DepthAverage) - 0.07 * DepthDelta) / (0.03 + 0.03 * DepthDelta));\n"
"//	color.rgb *= step(abs(DepthCenter - DepthAverage), 0.2 * DepthDelta);\n"
"# endif\n"
"#endif\n"
"\n"
"#ifdef USEFOG\n"
"	color.rgb = FogVertex(color);\n"
"#endif\n"
"\n"
"	// reflection must come last because it already contains exactly the correct fog (the reflection render preserves camera distance from the plane, it only flips the side) and ContrastBoost/SceneBrightness\n"
"#ifdef USEREFLECTION\n"
"	vec4 ScreenScaleRefractReflectIW = ScreenScaleRefractReflect * (1.0 / ModelViewProjectionPosition.w);\n"
"	//vec4 ScreenTexCoord = (ModelViewProjectionPosition.xyxy + normalize(cast_myhalf3(offsetMappedTexture2D(Texture_Normal)) - cast_myhalf3(0.5)).xyxy * DistortScaleRefractReflect * 100) * ScreenScaleRefractReflectIW + ScreenCenterRefractReflect;\n"
"	vec2 SafeScreenTexCoord = ModelViewProjectionPosition.xy * ScreenScaleRefractReflectIW.zw + ScreenCenterRefractReflect.zw;\n"
"	#ifdef USENORMALMAPSCROLLBLEND\n"
"# ifdef USEOFFSETMAPPING\n"
"		vec3 normal = dp_textureGrad(Texture_Normal, (TexCoord + vec2(0.08, 0.08)*ClientTime*NormalmapScrollBlend.x*0.5)*NormalmapScrollBlend.y, dPdx*NormalmapScrollBlend.y, dPdy*NormalmapScrollBlend.y).rgb - vec3(1.0);\n"
"# else\n"
"		vec3 normal = dp_texture2D(Texture_Normal, (TexCoord + vec2(0.08, 0.08)*ClientTime*NormalmapScrollBlend.x*0.5)*NormalmapScrollBlend.y).rgb - vec3(1.0);\n"
"# endif\n"
"		normal += dp_texture2D(Texture_Normal, (TexCoord + vec2(-0.06, -0.09)*ClientTime*NormalmapScrollBlend.x)*NormalmapScrollBlend.y*0.75).rgb;\n"
"		vec2 ScreenTexCoord = SafeScreenTexCoord + vec3(normalize(cast_myhalf3(normal))).xy * DistortScaleRefractReflect.zw;\n"
"	#else\n"
"		vec2 ScreenTexCoord = SafeScreenTexCoord + vec3(normalize(cast_myhalf3(offsetMappedTexture2D(Texture_Normal)) - cast_myhalf3(0.5))).xy * DistortScaleRefractReflect.zw;\n"
"	#endif\n"
"	// FIXME temporary hack to detect the case that the reflection\n"
"	// gets blackened at edges due to leaving the area that contains actual\n"
"	// content.\n"
"	// Remove this 'ack once we have a better way to stop this thing from\n"
"	// 'appening.\n"
"	float f = min(1.0, length(dp_texture2D(Texture_Reflection, ScreenTexCoord + vec2(0.01, 0.01)).rgb) / 0.05);\n"
"	f      *= min(1.0, length(dp_texture2D(Texture_Reflection, ScreenTexCoord + vec2(0.01, -0.01)).rgb) / 0.05);\n"
"	f      *= min(1.0, length(dp_texture2D(Texture_Reflection, ScreenTexCoord + vec2(-0.01, 0.01)).rgb) / 0.05);\n"
"	f      *= min(1.0, length(dp_texture2D(Texture_Reflection, ScreenTexCoord + vec2(-0.01, -0.01)).rgb) / 0.05);\n"
"	ScreenTexCoord = mix(SafeScreenTexCoord, ScreenTexCoord, f);\n"
"	color.rgb = mix(color.rgb, cast_myhalf3(dp_texture2D(Texture_Reflection, ScreenTexCoord)) * ReflectColor.rgb, ReflectColor.a);\n"
"#endif\n"
"\n"
"	dp_FragColor = vec4(color);\n"
"}\n"
"#endif // FRAGMENT_SHADER\n"
"\n"
"#endif // !MODE_DEFERREDLIGHTSOURCE\n"
"#endif // !MODE_DEFERREDGEOMETRY\n"
"#endif // !MODE_WATER\n"
"#endif // !MODE_REFRACTION\n"
"#endif // !MODE_BLOOMBLUR\n"
"#endif // !MODE_GENERIC\n"
"#endif // !MODE_POSTPROCESS\n"
"#endif // !MODE_SHOWDEPTH\n"
"#endif // !MODE_DEPTH_OR_SHADOW\n"
