
#include "quakedef.h"

#define WBUFFERSCALE 65536

int clipwidth, clipheight;
int *clipbuffer;

float r_clip_viewmatrix[3][4], r_clip_viewmulx, r_clip_viewmuly, r_clip_viewcenterx, r_clip_viewcentery;

void R_Clip_MakeViewMatrix()
{
	// this constructs a normal matrix, but it is used as an inverse matrix (translate before rotate, and rotation is transposed)...
	VectorCopy (vright, r_clip_viewmatrix[0]);
	VectorNegate (vup, r_clip_viewmatrix[1]);
	VectorCopy (vpn, r_clip_viewmatrix[2]);
	r_clip_viewmatrix[0][3] = r_refdef.vieworg[0];
	r_clip_viewmatrix[1][3] = r_refdef.vieworg[1];
	r_clip_viewmatrix[2][3] = r_refdef.vieworg[2];
}

void R_Clip_StartFrame()
{
	if (vid.width != clipwidth || vid.height != clipheight || !clipbuffer)
	{
		if (clipbuffer)
			qfree(clipbuffer);
		clipwidth = vid.width;
		clipheight = vid.height;
		clipbuffer = qmalloc(clipwidth * clipheight * sizeof(int) * 2);
		r_clip_viewmulx = clipwidth * 0.5;
	}
	memset(clipbuffer, 0, clipwidth * clipheight * sizeof(int) * 2);
}

void R_Clip_EndFrame()
{
}

void r_clip_start()
{
}

void r_clip_shutdown()
{
	if (clipbuffer)
		qfree(clipbuffer);
	clipbuffer = NULL;
	clipwidth = -1;
	clipheight = -1;
}

void R_Clip_Init()
{
	R_RegisterModule("R_Clip", r_clip_start, r_clip_shutdown);
}

void R_Clip_TransformToView(vec3_t in, vec3_t out)
{
	vec3_t v, t;
	v[0] = in[0] - r_clip_viewmatrix[0][3];
	v[1] = in[1] - r_clip_viewmatrix[1][3];
	v[2] = in[2] - r_clip_viewmatrix[2][3];
	t[0] = r_clip_viewmatrix[0][0] * v[0] + r_clip_viewmatrix[1][0] * v[1] + r_clip_viewmatrix[2][0] * v[2];
	t[1] = r_clip_viewmatrix[0][1] * v[0] + r_clip_viewmatrix[1][1] * v[1] + r_clip_viewmatrix[2][1] * v[2];
	t[2] = r_clip_viewmatrix[0][2] * v[0] + r_clip_viewmatrix[1][2] * v[1] + r_clip_viewmatrix[2][2] * v[2];
	dist = 1 / t[2];
	out[0] = t[0] * r_clip_viewmulx * dist + r_clip_viewcenterx;
	out[1] = t[1] * r_clip_viewmuly * dist + r_clip_viewcentery;
	out[2] = dist;
}
