SET(OBD_SIMGEN_RANDOM "On" CACHE BOOL "Enable Random obdsim generator")

INCLUDE(CheckFunctionExists)
CHECK_FUNCTION_EXISTS(random HAVE_RANDOM)
CHECK_FUNCTION_EXISTS(srandom HAVE_SRANDOM)
CHECK_FUNCTION_EXISTS(rand HAVE_RAND)
CHECK_FUNCTION_EXISTS(srand HAVE_SRAND)

IF(HAVE_RANDOM)
	ADD_DEFINITIONS(-DHAVE_RANDOM)
ELSEIF(HAVE_RAND)
	ADD_DEFINITIONS(-DHAVE_RAND)
ELSE(HAVE_RANDOM)
	MESSAGE(STATUS "Cannot build Random generator without rand() or random()")
	SET(OBD_SIMGEN_RANDOM "Off" CACHE BOOL "Enable Random obdsim generator")
ENDIF(HAVE_RANDOM)

IF(HAVE_SRANDOM)
	ADD_DEFINITIONS(-DHAVE_SRANDOM)
ELSEIF(HAVE_SRAND)
	ADD_DEFINITIONS(-DHAVE_SRAND)
ENDIF(HAVE_SRANDOM)

IF(OBD_SIMGEN_RANDOM)
	FILE(GLOB OBDSIMGEN_RANDOM_SRCS
		generators/random/*.c
	)
	ADD_LIBRARY(ckobdsim_random STATIC ${OBDSIMGEN_RANDOM_SRCS})
	SET(GENERATOR_LIBS ${GENERATOR_LIBS} ckobdsim_random)
	ADD_DEFINITIONS(-DOBDSIMGEN_RANDOM)
ENDIF(OBD_SIMGEN_RANDOM)

