SET(GPSD_FOUND "NO")

SET(CHUNKY_INSTALLED_GPSD_ON_HIS_MAC_IN $ENV{HOME}/gpsd/)

SET(GPSD_PREFIX "/usr/local/gpsd/" CACHE STRING
	"GPSD is installed in this prefix (if non-standard)")

SET(GPSD_SEARCH_PATHS
	${CHUNKY_INSTALLED_GPSD_ON_HIS_MAC_IN}/
	${GPSD_PREFIX}/
	/sw/
	/usr/
	/usr/local/
)

FIND_PATH(GPSD_INCLUDE_DIR
	NAMES gps.h
	PATH_SUFFIXES /include/
	PATHS ${GPSD_SEARCH_PATHS}
)

FIND_LIBRARY(GPSD_LIBRARY
	NAMES gps
	PATH_SUFFIXES /lib/
	PATHS ${GPSD_SEARCH_PATHS}
)

FIND_PROGRAM(GPSD_DAEMON
	NAMES gpsd
	PATH_SUFFIXES /sbin/ /bin/
	PATHS ${GPSD_SEARCH_PATHS}
)


IF(GPSD_LIBRARY AND GPSD_INCLUDE_DIR)
  SET(GPSD_FOUND "YES")
ENDIF(GPSD_LIBRARY AND GPSD_INCLUDE_DIR)

IF(GPSD_FOUND)
  IF(NOT GPSD_FIND_QUIETLY)
    MESSAGE(STATUS "Found GPSD: ${GPSD_LIBRARY},${GPSD_LIBRARY}")
  ENDIF(NOT GPSD_FIND_QUIETLY)
ELSE(GPSD_FOUND)
  IF(GPSD_FIND_REQUIRED)
    MESSAGE(FATAL_ERROR "Could not find GPSD Library")
  ENDIF(GPSD_FIND_REQUIRED)
ENDIF(GPSD_FOUND)

