#include <config.h>
#include <gtk/gtk.h>
#include "fileselectionview.h"
#include <gui/support.h>
#include <tool/fileseltool.h>



static GtkWidget* create_file_selection (void *data);
static void
on_ok_filesel_clicked                  (GtkButton       *button,
                                        gpointer         user_data);
static void
on_cancel_filesel_clicked              (GtkButton       *button,
                                        gpointer         user_data);

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  gtk_object_set_data_full (GTK_OBJECT (component), name, \
    gtk_widget_ref (widget), (GtkDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  gtk_object_set_data (GTK_OBJECT (component), name, widget)

static GtkWidget*
create_file_selection (void *data)
{
  GtkWidget *file_selection;
  GtkWidget *ok_filesel;
  GtkWidget *cancel_filesel;

  file_selection = gtk_file_selection_new (_("Select a file"));
  gtk_container_set_border_width (GTK_CONTAINER (file_selection), 10);

  ok_filesel = GTK_FILE_SELECTION (file_selection)->ok_button;
  gtk_widget_show (ok_filesel);
  GTK_WIDGET_SET_FLAGS (ok_filesel, GTK_CAN_DEFAULT);

  cancel_filesel = GTK_FILE_SELECTION (file_selection)->cancel_button;
  gtk_widget_show (cancel_filesel);
  GTK_WIDGET_SET_FLAGS (cancel_filesel, GTK_CAN_DEFAULT);

  gtk_signal_connect (GTK_OBJECT (ok_filesel), "clicked",
                      GTK_SIGNAL_FUNC (on_ok_filesel_clicked),
                      data);
  gtk_signal_connect (GTK_OBJECT (cancel_filesel), "clicked",
                      GTK_SIGNAL_FUNC (on_cancel_filesel_clicked),
                      data);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (file_selection, file_selection, "file_selection");
  GLADE_HOOKUP_OBJECT_NO_REF (file_selection, ok_filesel, "ok_filesel");
  GLADE_HOOKUP_OBJECT_NO_REF (file_selection, cancel_filesel, "cancel_filesel");

  return file_selection;
}

static void
on_ok_filesel_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
    FileSelectionView *fs = (FileSelectionView*)user_data;
    GtkFileSelection *gtkfs = GTK_FILE_SELECTION(lookup_widget(GTK_WIDGET(button),"file_selection"));
    if (gtkfs) {
	fs->selected(gtk_file_selection_get_filename(gtkfs));
    } else {
	std::cerr << "on_ok_filesel_clicked: Can't access GtkFileSelection" << std::endl;
    }
    gtk_widget_destroy(lookup_widget(GTK_WIDGET(button),"file_selection"));
}


static void
on_cancel_filesel_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
    gtk_widget_destroy(lookup_widget(GTK_WIDGET(button),"file_selection"));
}


FileSelectionView::FileSelectionView() {
    filesel=0;
}
FileSelectionView::~FileSelectionView() {
    gtk_widget_destroy(filesel);
}

void FileSelectionView::enable() {
    filesel = create_file_selection(this);
    gtk_widget_show(filesel);
}

void FileSelectionView::selected(const char *file) {
    FileSelTool *tool=dynamic_cast<FileSelTool*>(activeTool.get());
    tool->fileSelected(file);
}
