#ifndef __TOOL_ZOOM_H__
#define __TOOL_ZOOM_H__

#include "tool.h"
#include <editor.h>

class ToolZoomIn: public Tool {
public:
    ToolZoomIn(): Tool("zoom_in") {}
    virtual void init() {
	CameraView *v=editor->getCameraView();
        v->setZoom(v->getZoom()*2);
    }
    virtual Tool* clone() { return new ToolZoomIn(); }

};

class ToolZoomOut: public Tool {
public:
    ToolZoomOut(): Tool("zoom_out") {}
    virtual void init() {
	CameraView *v=editor->getCameraView();
        v->setZoom(v->getZoom()/2);
    }
    virtual Tool* clone() { return new ToolZoomOut(); }

};

#endif
