#ifndef __TOOL_TEXTURE_H__
#define __TOOL_TEXTURE_H__

#include <osg/Texture2D>
#include "toolstateattribute.h"

class ToolTexture: public ToolStateAttribute {
public:
    ToolTexture(): ToolStateAttribute("texture") {}
    virtual osg::StateAttribute::Type getType() {
	return osg::StateAttribute::TEXTURE;
    }
    virtual osg::StateAttribute *generate() {
        return new osg::Texture2D();
    }
    virtual Tool* clone() { return new ToolTexture(); }
    virtual osg::StateAttribute *checkCast(osg::StateAttribute *source) {
	return dynamic_cast<osg::Texture2D*>(source);
    }
};

#endif
