#ifndef __TOOL_STATE_SET_H__
#define __TOOL_STATE_SET_H__

#include <osg/StateSet>
#include "tool.h"
#include <gui/properties.h>

/** @class ToolStateSet
 * @brief Superclass of tools for editing of state attributes
 *
 * Implements template pattern to automate common tasks when editing
 * state attributes. You must implement only the last three methods.
 */
class ToolStateSet: public Tool {
public:
    ToolStateSet(): Tool("state_set") {}
    virtual ~ToolStateSet() {}
    virtual void selected(osg::Node *node, osg::Group *parent) {
	osg::StateSet* set = node->getOrCreateStateSet();
        editor->editObject(set);
    }

    virtual Tool* clone() { return new ToolStateSet(); }
};

#endif
