#ifndef __TOOL_STATE_ATTRIBUTE_H__
#define __TOOL_STATE_ATTRIBUTE_H__

#include <osg/StateAttribute>
#include "tool.h"
#include <gui/properties.h>

/** @class ToolStateAttribute
 * @brief Superclass of tools for editing of state attributes
 *
 * Implements template pattern to automate common tasks when editing
 * state attributes. You must implement only the last three methods.
 */
class ToolStateAttribute: public Tool {
public:
    ToolStateAttribute(std::string name): Tool(name) {}
    virtual ~ToolStateAttribute() {}
    virtual void selected(osg::Node *node, osg::Group *parent) {
	osg::ref_ptr<osg::StateSet> valid = node->getOrCreateStateSet();
	osg::StateAttribute *attribute=checkCast(valid->getAttribute(getType()));
	if (!attribute) {
            attribute=generate();
	    valid->setAttributeAndModes(attribute, osg::StateAttribute::ON);
	}
        editor->editObject(attribute);
    }

    /** You can make a dynamic_cast here to ensure that the state attribute
     * is good for your tool */
    virtual osg::StateAttribute *checkCast(osg::StateAttribute *source) {
        return source;
    }
    virtual osg::StateAttribute::Type getType()=0;
    virtual osg::StateAttribute *generate()=0;
    virtual Tool* clone()=0;
};

#endif
