#ifndef __TOOL_SCALE_H__
#define __TOOL_SCALE_H__

#include "drawingareatool.h"
#include <osg/MatrixTransform>


class ToolScale: public DrawingAreaTool {
    osg::ref_ptr<osg::MatrixTransform> node;
    bool clicked;
    osg::Matrix original;
    float y0;
    float y1;
public:
    ToolScale(): DrawingAreaTool("scale") { clicked=0; }
    virtual void selected(osg::Node *node, osg::Group *parent);
    virtual void mouseMoved(float x, float y);
    virtual void mousePressed();
    virtual void mouseReleased();
    virtual void init() { clicked=0; }
    virtual Tool* clone() { return new ToolScale(); }

};

#endif
