#include <config.h>
#include "toolscale.h"
#include <editor.h>
#include <command/comscale.h>

#define FACTOR 2

void ToolScale::selected(osg::Node *node, osg::Group *parent) {
    this->node = dynamic_cast<osg::MatrixTransform*>(node);
    if (this->node == 0) {
        throw _("You can only scale Transform nodes");
    }
}

void ToolScale::mouseMoved(float x, float y) {
    if (node.valid()) {
	if (clicked) {
	    y1=y;
	    float scale=1+(y1-y0)*FACTOR;
	    osg::Matrix t;
	    t.makeScale(scale,scale,scale);
	    node->setMatrix(original*t);
	} else {
            y0=y;
	}
    }
}

void ToolScale::mousePressed() {
    if (node.valid()) {
	clicked=true;
	original=this->node->getMatrix();
	osg::StateSet *stateset=node->getStateSet();
	if (stateset==0) {
	    stateset=new osg::StateSet();
	    stateset->setMode(GL_NORMALIZE,osg::StateAttribute::ON);
            node->setStateSet(stateset);
	} else {
            stateset->setMode(GL_NORMALIZE,osg::StateAttribute::ON);
	}
	y1=y0;
    }
}

void ToolScale::mouseReleased() {
    /* Build a command and apply it! */
    if (node.valid()) {
	this->node->setMatrix(original);
	float scale=1+(y1-y0)*FACTOR;
	osg::ref_ptr<ComScale> cmd=new ComScale(node.get(),scale);
	cmd->execute();
	clicked=0;
	y0=y1;
    }
}

