#ifndef __TOOL_ROTATE_H__
#define __TOOL_ROTATE_H__

#include "drawingareatool.h"
#include <osg/MatrixTransform>


class ToolRotate: public DrawingAreaTool {
    osg::ref_ptr<osg::MatrixTransform> node;
    bool clicked;
    osg::Matrix original;
    osg::Vec3 quat_vec;
    float y0;
    float y1;
public:
    ToolRotate(): DrawingAreaTool("rotate") { clicked=0; }
    virtual void selected(osg::Node *node, osg::Group *parent);
    virtual void mouseMoved(float x, float y);
    virtual void mousePressed();
    virtual void mouseReleased();
    virtual void init() { clicked=0; }
    virtual Tool* clone() { return new ToolRotate(); }

};

#endif
