#include <config.h>
#include "toolrotate.h"
#include <editor.h>
#include <command/comrotate.h>

#define PI 3.141592654
#define FACTOR 2*PI

void ToolRotate::selected(osg::Node *node, osg::Group *parent) {
    this->node = dynamic_cast<osg::MatrixTransform*>(node);
    if (this->node == 0) {
        throw _("You can only rotate Transform nodes");
    }
}

void ToolRotate::mouseMoved(float x, float y) {
    if (node.valid()) {
	if (clicked) {
            y1=y;
	    osg::Matrix t;
	    t.makeRotate((y0-y1)*FACTOR,quat_vec);
	    node->setMatrix(original*t);
	} else {
            y0=y;
	}
    }
}

void ToolRotate::mousePressed() {
    osg::Camera *camera = editor->getCameraView()->getSceneView()->getCamera();
    osg::Matrix matrix = camera->getModelViewMatrix();
    osg::Matrix matrix2 = camera->getProjectionMatrix();
    osg::Matrix parent_inv = osg::Matrix::inverse(editor->getSceneGraph()->getParentTransform());
    osg::Matrix transform =osg::Matrix::inverse(matrix) * osg::Matrix::inverse(matrix2) * parent_inv;
    quat_vec=osg::Vec3(0,0,1)*transform;
    if (node.valid()) {
	clicked=true;
	original=this->node->getMatrix();
	y1=y0;
    }
}

void ToolRotate::mouseReleased() {
    /* Build a command and apply it! */
    if (node.valid()) {
	this->node->setMatrix(original);
	osg::ref_ptr<ComRotate> cmd=new ComRotate(node.get(),quat_vec,(y0-y1)*FACTOR);
	cmd->execute();
	clicked=0;
	y0=y1;
    }
}

