#include "toolpick.h"
#include <osg/NodeVisitor>
#include <osgUtil/IntersectVisitor>

void ToolPick::mouseMoved(float x, float y) {
    mouse[0] = (x - 0.5f)*2;
    mouse[1] = (y - 0.5f)*2;
}

void ToolPick::mousePressed() {
    osg::Camera *camera = editor->getCameraView()->getSceneView()->getCamera();
    osg::ref_ptr<osgUtil::SceneView> sceneView=editor->getCameraView()->getSceneView();
    osg::Vec3 near_point,far_point;
    if (!sceneView->projectWindowXYIntoObject((int)mouse[0],(int)mouse[1],near_point,far_point)) {
	return;
    }
    osg::Matrix matrix = camera->getModelViewMatrix();
    osg::Matrix matrix2 = camera->getProjectionMatrix();
    osg::Matrix inv = osg::Matrix::inverse(matrix*matrix2*osg::Matrix::translate(0,0,1)*osg::Matrix::scale(1,1,0.5f));
    near_point=osg::Vec3(mouse[0],mouse[1],0.0f)*inv;
    far_point=osg::Vec3(mouse[0],mouse[1],1.0f)*inv;
    osg::ref_ptr<osg::LineSegment> lineSegment = new osg::LineSegment;
    lineSegment->set(near_point,far_point);

    osgUtil::IntersectVisitor iv;
    iv.addLineSegment(lineSegment.get());

    editor->getSceneGraph()->getRoot()->accept(iv);
    if (iv.hits())
    {
	osgUtil::IntersectVisitor::HitList& hitList = iv.getHitList(lineSegment.get());
	for(osgUtil::IntersectVisitor::HitList::iterator hitr=hitList.begin();
	    hitr!=hitList.end();
	    ++hitr)
	{
	    osg::Geode* geode = hitr->_geode.get();
	    if (geode) {
		editor->selectNode(hitr->_geode.get(), hitr->_nodePath);
                return;
	    }
	}

    }

}
