#ifndef __TOOL_PASTE_H__
#define __TOOL_PASTE_H__

#include "tool.h"
#include <clipboard.h>
#include <command/comaddchild.h>

class ToolPaste: public Tool {
public:
    ToolPaste(): Tool("paste") {}
    virtual void selected(osg::Node *node, osg::Group *parent) {
	osg::Node *n = Clipboard::getContents();
	osg::Group *g = dynamic_cast<osg::Group*>(node);
	if (g!=0) {
	    osg::ref_ptr<ComAddChild> cmd=new ComAddChild(n,g,editor->getSceneGraph());
            cmd->execute();
	} else {
            throw _("Can only paste into group nodes!");
	}
    }
    virtual Tool* clone() { return new ToolPaste(); }
};

#endif
