#ifndef __TOOL_PAN_H__
#define __TOOL_PAN_H__

#include "drawingareatool.h"
#include <osg/MatrixTransform>

/** @class ToolPan
 * @brief Moves the camera without rotating it
 */
class ToolPan: public DrawingAreaTool {
    osg::Vec3 source;
    osg::Vec3 target;
    bool clicked;
    osg::Matrix transform; // camera transformation matrix ;D
public:
    ToolPan(): DrawingAreaTool("pan") { clicked=0; }
    virtual void mouseMoved(float x, float y);
    virtual void mousePressed();
    virtual void mouseReleased();
    virtual void init();
    virtual Tool* clone() { return new ToolPan(); }


};

#endif
