#include "toolpan.h"
#include <editor.h>
#include <command/comtranslate.h>

void ToolPan::mouseMoved(float x, float y) {
    x=-x;
    y=-y;
    if (clicked) {
	target=osg::Vec3(2*x,2*y,0)*transform;
	osg::Vec3 displ=(target-source);
	editor->getCameraView()->moveCamera(displ[0],displ[1],displ[2]);
    }
    source=osg::Vec3(2*x,2*y,0)*transform;
}

void ToolPan::mousePressed() {
    clicked=true;
}

void ToolPan::mouseReleased() {
    clicked=false;
}


void ToolPan::init() {
    clicked=0;
    osg::Camera *camera = editor->getCameraView()->getSceneView()->getCamera();
    osg::Matrix matrix = camera->getModelViewMatrix();
    osg::Matrix matrix2 = camera->getProjectionMatrix();
    transform = osg::Matrix::inverse(matrix2) * osg::Matrix::inverse(matrix);
}
