#ifndef __TOOL_ORBIT_H__
#define __TOOL_ORBIT_H__

#include "drawingareatool.h"
#include <osg/MatrixTransform>

/** @class ToolOrbit
 * @brief Makes the camera orbit in a trackball-like manner using the mouse
 */
class ToolOrbit: public DrawingAreaTool {
    osg::Vec2 source;
    osg::Vec2 target;
    bool clicked;
public:
    ToolOrbit(): DrawingAreaTool("orbit") { clicked=0; }
    virtual void mouseMoved(float x, float y);
    virtual void mousePressed();
    virtual void mouseReleased();
    virtual void init() { clicked=0; }
    virtual Tool* clone() { return new ToolOrbit(); }


};

#endif
