#ifndef __TOOL_MOVE_H__
#define __TOOL_MOVE_H__

#include "drawingareatool.h"
#include <osg/MatrixTransform>


class ToolMove: public DrawingAreaTool {
    osg::ref_ptr<osg::MatrixTransform> node;
    osg::Vec3 source;
    osg::Vec3 target;
    bool clicked;
    osg::Matrix original;
public:
    ToolMove(): DrawingAreaTool("move") { clicked=0; }
    virtual void selected(osg::Node *node, osg::Group *parent);
    virtual void mouseMoved(float x, float y);
    virtual void mousePressed();
    virtual void mouseReleased();
    virtual void init() { clicked=0; }
    virtual Tool* clone() { return new ToolMove(); }


};

#endif
