#include <config.h>
#include "toolmove.h"
#include <editor.h>
#include <command/comtranslate.h>

void ToolMove::selected(osg::Node *node, osg::Group *parent) {
    this->node = dynamic_cast<osg::MatrixTransform*>(node);
    if (this->node == 0) {
        throw _("You can only move Transform nodes");
    }
}

void ToolMove::mouseMoved(float x, float y) {
    if (node.valid()) {
	osg::Camera *camera = editor->getCameraView()->getSceneView()->getCamera();
	osg::Matrix matrix = camera->getModelViewMatrix();
	osg::Matrix matrix2 = camera->getProjectionMatrix();
	osg::Matrix parent_inv = osg::Matrix::inverse(editor->getSceneGraph()->getParentTransform());
	osg::Matrix transform = osg::Matrix::inverse(matrix2) * osg::Matrix::inverse(matrix) * parent_inv;
	if (!clicked) {
	    source=osg::Vec3(2*x,2*y,0)*transform;
	} else {
	    target=osg::Vec3(2*x,2*y,0)*transform;
	    osg::Matrix t;
	    t.makeTranslate(target-source);
	    node->setMatrix(original*t);
	}
    }
}

void ToolMove::mousePressed() {
    if (node.valid()) {
	clicked=true;
	original=this->node->getMatrix();
	target=source;
    }
}

void ToolMove::mouseReleased() {
    /* Build a command and apply it! */
    if (node.valid()) {
	this->node->setMatrix(original);
	osg::ref_ptr<ComTranslate> cmd=new ComTranslate(node.get(),target-source);
	cmd->execute();
	clicked=0;
	source=target;
    }
}

