#ifndef __TOOL_MERGE_H__
#define __TOOL_MERGE_H__

#include "fileseltool.h"
#include <gui/warning.h>

class ToolMerge: public FileSelTool {
public:
    ToolMerge(): FileSelTool("merge") {}
    virtual void fileSelected(const char *n) {
	osg::Node *node = editor->getSceneGraph()->loadFile(n);
	osg::Group *selected = dynamic_cast<osg::Group*>(editor->getSelected());
	if (selected != 0) {
	    osg::ref_ptr<ComAddChild> com=new ComAddChild(node,selected,editor->getSceneGraph());
            com->execute();
	} else {
            my_warning("Can only merge nodes in groups");
	}
    }
    virtual Tool* clone() { return new ToolMerge(); }

};

#endif
