#ifndef __TOOL_MAKE_SHAPE_H__
#define __TOOL_MAKE_SHAPE_H__

#include <osg/Geode>
//#include <osg/Shape>
#include <osg/ShapeDrawable>
#include "drawingareatool.h"
//#include <clipboard.h>

/**
 * Abstract class for all the shape makers. Subclasses of this tool have
 * only to define a constructor and copy method as always, and
 * a makeShape() function to make the concrete shape.
 * A getPos() method is provided to subclases in order to know where in the
 * space the user want to put the shape.
 */
class ToolMakeShape: public DrawingAreaTool {
    osg::Vec3 pos;
    osg::ref_ptr<osg::Group> parent;
protected:
    /// API for the subclasses to know where they may be put
    osg::Vec3 getPos() { return pos; }
public:
    ToolMakeShape(char *name): DrawingAreaTool(name) {}
    virtual void mouseMoved(float x, float y) {
	pos=osg::Vec3(2*(x-0.5),2*(y-0.5),0);
    }
    virtual void mouseReleased() {
        // Put the sphere in the mouse location (more or less, mouse is in 2D ;)
	osg::Camera *camera = editor->getCameraView()->getSceneView()->getCamera();
	osg::Matrix matrix = camera->getModelViewMatrix();
	osg::Matrix matrix2 = camera->getProjectionMatrix();
	osg::Matrix transform = osg::Matrix::inverse(matrix2) * osg::Matrix::inverse(matrix);
	if (parent.valid()) {
            pos=pos*transform;
	    osg::ref_ptr<osg::Geode> geode = new osg::Geode();
	    geode->addDrawable(new osg::ShapeDrawable(makeShape()));
	    osg::ref_ptr<ComAddChild> com = new ComAddChild(geode.get(),parent.get(),editor->getSceneGraph());
	    com->execute();
	}
    }

    virtual void selected(osg::Node *node, osg::Group *parent) {
	this->parent=dynamic_cast<osg::Group*>(node);
	if (this->parent == 0) {
	    throw _("Can only add children to group nodes!");
	}
    }

    /// Template method to make the actual shape
    virtual osg::Shape *makeShape()=0;
};


#endif
