#ifndef __TOOL_DELETE_H__
#define __TOOL_DELETE_H__

#include "tool.h"
#include <command/comdelete.h>
#include <gui/warning.h>

class ToolDelete: public Tool {
public:
    ToolDelete(): Tool("delete") {}
    virtual void selected(osg::Node *node, osg::Group *parent) {
        if (parent == 0) my_warning(_("You can not delete the root node"));
	osg::ref_ptr<ComDelete> cd=new ComDelete(node,parent,editor->getSceneGraph());
	cd->execute();
	osg::NodePath p;
	editor->selectNode(0,p);
    }
    virtual Tool* clone() { return new ToolDelete(); }

};

#endif
