#ifndef __TOOL_CENTER_SELECTION_H__
#define __TOOL_CENTER_SELECTION_H__

#include "tool.h"
#include <clipboard.h>

class ToolCenterSelection: public Tool {
public:
    ToolCenterSelection(): Tool("center-selection") {}
    virtual void selected(osg::Node *node, osg::Group *parent) {
	osg::Matrix parent_trans = editor->getSceneGraph()->getParentTransform();
	osg::Vec3 center = node->getBound().center();
        center = center * parent_trans;
	editor->getCameraView()->setCenter(center[0],center[1],center[2]);
    }
    virtual Tool* clone() { return new ToolCenterSelection(); }
};

#endif
