#ifndef __OSG_TREE_H__
#define __OSG_TREE_H__

//#include <gtk/gtktreestore.h>
#include <osg/Node>
#include <string>

class OsgTreeModel: public osg::Referenced {
protected:
    osg::ref_ptr<osg::Node> root;
public:
    OsgTreeModel(osg::Node *root=0);
    virtual void update()=0; // Updates all the tree
    virtual void addChild(osg::Group *parent, osg::Node *child)=0;
    virtual void removeChild(osg::Group *parent, osg::Node *child)=0;
    virtual void renameNode(osg::Node *node, std::string name)=0;
    void setRootNode(osg::Node *root);

    // changes the current selection in this tree model
    virtual void select(osg::NodePath &path)=0;
};

#endif
