#ifndef __GTK_VIEWER_H__
#define __GTK_VIEWER_H__

#ifdef WIN32
# include <windows.h>
#endif
#include "gtkglwidget.h"
#include <osgGA/GUIEventAdapter>
#include <osgGA/GUIActionAdapter>
#include <osgGA/CameraManipulator>
#include <osgUtil/SceneView>
#include "gtkeventadapter.h"
#include <osg/Timer>

/**
 * Cosa como el osgGLUT::Viewer, pero para GtkGLArea en lugar de GLUT
 */
class EXPORT GtkViewer: public GtkGLWidget, public osgGA::GUIActionAdapter {
public:
    GtkViewer();
    virtual ~GtkViewer();

    virtual void addViewport(osgUtil::SceneView* sv,
			     float x     = 0.0, float y      = 0.0,
			     float width = 1.0, float height = 1.0);

    virtual void addViewport(osg::Node*,
			     float x     = 0.0, float y      = 0.0,
			     float width = 1.0, float height = 1.0);

    const int getNumViewports() const { return _viewportList.size(); }
    osgUtil::SceneView* getViewportSceneView(unsigned int pos)
    { return _viewportList[pos].sceneView.get(); }

    virtual bool open();
    virtual void display();

    // called on each frame redraw..return the time in ms for each operation.
    virtual float app(unsigned int viewport);
    virtual float cull(unsigned int viewport);
    virtual float draw(unsigned int viewport);

    // handle multiple camera.
    unsigned int registerCameraManipulator(osgGA::CameraManipulator* cm,
					   unsigned int viewport = 0);
    void selectCameraManipulator(unsigned int pos,
				 unsigned int viewport = 0);

    // derived from osgUtil::GUIActionAdapter
    virtual void requestRedraw() {} // redraw always by idle callback done.
    virtual void requestContinuousUpdate(bool /*needed*/) {} // continuous update always
    virtual void requestWarpPointer(float x,float y);
    float clockSeconds() { return _timer.delta_s(_initialTime,_timer.tick()); }
protected:
    virtual void mouseRelease(int button);
    virtual void mousePress(int button);
    virtual void mouseMotion(double x, double y);
    virtual void reshape(double width, double height);

    GtkEventAdapter *makeEvent();

    void setFocusedViewport(unsigned int pos);
    int mapWindowXYToSceneView(int x, int y);

    typedef std::vector<osg::ref_ptr<osgGA::CameraManipulator> > CameraManipList;

    struct ViewportDef
    {
	osg::ref_ptr<osgUtil::SceneView> sceneView;
	float viewport[4];                        // Win-size-relative [0,1]

	osg::ref_ptr<osgGA::CameraManipulator>    _cameraManipulator;
	CameraManipList                             _cameraManipList;
    };

    typedef std::vector<ViewportDef> ViewportList;
    ViewportList _viewportList;
    osg::ref_ptr<osg::FrameStamp> _frameStamp;
    osg::Timer   _timer;
    osg::Timer_t _initialTime;

    osg::ref_ptr<osg::DisplaySettings>  _displaySettings;
    unsigned int _focusedViewport;
};

#endif // __GTK_VIEWER_H__
