#ifndef __GTK_GL_WIDGET_H__
#define __GTK_GL_WIDGET_H__

#ifdef WIN32
#  define EXPORT __declspec(dllexport)
# include <windows.h>
#else
#  define EXPORT
#endif

#include <gtk/gtk.h>
#include <gtkgl/gtkglarea.h>


/**
 * Cosa como el osgGLUT::Window, pero para GtkGLArea en lugar de GLUT
 */
class EXPORT GtkGLWidget {
public:
    GtkGLWidget();
    GtkWidget *getWidget() { return _glarea; }
    void setWidgetSize(int width, int height);

    virtual bool open();
    virtual void display();

protected:
    virtual void mouseRelease(int button);
    virtual void mousePress(int button);
    virtual void mouseMotion(double x, double y);
    virtual void reshape(double width, double height);

    void swapBuffers();

private:
    friend gint button_press_hnd(GtkWidget *widget, GdkEventButton *event, GtkGLWidget *v);
    friend gint button_release_hnd(GtkWidget *widget, GdkEventButton *event, GtkGLWidget  *v);
    friend gint motion_hnd(GtkWidget *widget, GdkEventMotion *event, GtkGLWidget  *v);
    friend gint reshape_hnd(GtkWidget *widget,GdkEventConfigure *event,GtkGLWidget  *v);

protected:
    int _width;
    int _height;
    double _mx;
    double _my;
    unsigned _buttonMask;


private:
    GtkWidget *_glarea;
};

#endif //__GTK_GL_WIDGET_H__
