#include "gtkglwidget.h"
#include <iostream>
#include <GL/gl.h>

gint dibujar_hnd(GtkWidget *widget,GdkEventExpose *event,GtkGLWidget *v);
gint reshape_hnd(GtkWidget *widget,GdkEventConfigure *event, GtkGLWidget *v);
gint button_press_hnd(GtkWidget *widget,GdkEventButton *event,GtkGLWidget *v);
gint button_release_hnd(GtkWidget *widget, GdkEventButton *event,GtkGLWidget *v);
gint motion_hnd(GtkWidget *widget,GdkEventMotion *event,GtkGLWidget *v);

/************************************************************************/
GtkGLWidget::GtkGLWidget() {
    _glarea=0;
    _mx=0;
    _my=0;
    _buttonMask=0;
}

void GtkGLWidget::setWidgetSize(int width, int height) {
    gtk_widget_set_usize(_glarea,width, height);
}


void GtkGLWidget::mouseRelease(int button) {
    _buttonMask&=~(1<<(button-1));
}

void GtkGLWidget::mousePress(int button) {
    _buttonMask|=1<<(button-1);
}

void GtkGLWidget::mouseMotion(double x, double y) {
    _mx=x;
    _my=y;
}

void GtkGLWidget::reshape(double width, double height){
    _width=(int)width;
    _height=(int)height;
}

bool GtkGLWidget::open() {
    if (gdk_gl_query() == FALSE) {
	g_print("OpenGL not supported\n");
	return false;
    }
    _glarea = gtk_gl_area_new_vargs(NULL, /* no sharing */
				    GDK_GL_RGBA,
				    GDK_GL_RED_SIZE,1,
				    GDK_GL_GREEN_SIZE,1,
				    GDK_GL_BLUE_SIZE,1,
				    GDK_GL_DEPTH_SIZE,1,
				    GDK_GL_DOUBLEBUFFER,
				    GDK_GL_NONE);  /* last argument must be GDK_GL_NONE */

    gtk_widget_set_events(_glarea,
			  GDK_EXPOSURE_MASK
			  |GDK_POINTER_MOTION_MASK
			  |GDK_BUTTON_PRESS_MASK
			  |GDK_BUTTON_RELEASE_MASK);

    gtk_signal_connect(GTK_OBJECT(_glarea),"expose-event",
		       GTK_SIGNAL_FUNC(dibujar_hnd),this);
    gtk_signal_connect(GTK_OBJECT(_glarea),"configure-event",
		       GTK_SIGNAL_FUNC(reshape_hnd),this);
    gtk_signal_connect(GTK_OBJECT(_glarea),"button-press-event",
                       GTK_SIGNAL_FUNC(button_press_hnd),this);
    gtk_signal_connect(GTK_OBJECT(_glarea),"button-release-event",
                       GTK_SIGNAL_FUNC(button_release_hnd),this);
    gtk_signal_connect(GTK_OBJECT(_glarea),"motion-notify-event",
                       GTK_SIGNAL_FUNC(motion_hnd),this);
    gtk_widget_set_usize(_glarea,300,300);
    gtk_widget_show(_glarea);

    return true;
}

void GtkGLWidget::display() {
    std::cout << "GtkWidget::display" << std::endl;
}


void GtkGLWidget::swapBuffers() {
    if (gtk_gl_area_make_current(GTK_GL_AREA(_glarea))) {
	gtk_gl_area_swap_buffers(GTK_GL_AREA(_glarea));
    }
}



/************************************************************************/
gint dibujar_hnd(GtkWidget *widget,
		 GdkEventExpose *event,
		 GtkGLWidget  *v) {
    /* Draw only last expose. */
    if (event && event->count > 0)
	return TRUE;
    if (gtk_gl_area_make_current(GTK_GL_AREA(widget)))
    {
	v->display();
    } else {
	std::cerr << "Error haciendo 'current'" << std::endl;
    }
    return TRUE;
}

/************************************************************************/
/* When glarea widget size changes, viewport size is set to match the new size */
gint reshape_hnd(GtkWidget *widget,
		 GdkEventConfigure *event,
		 GtkGLWidget  *v)
{
    /* OpenGL functions can be called only if make_current returns true */
    if (gtk_gl_area_make_current(GTK_GL_AREA(widget)))
    {
	//glViewport(0,0, widget->allocation.width, widget->allocation.height);
	v->reshape(widget->allocation.width, widget->allocation.height);
    }
    return TRUE;
}

/************************************************************************/
gint button_press_hnd(GtkWidget          *widget,
		      GdkEventButton     *event,
		      GtkGLWidget                *v) {
    v->mousePress(event->button);
    return TRUE;
}

/************************************************************************/
gint button_release_hnd(GtkWidget          *widget,
			       GdkEventButton     *event,
			       GtkGLWidget                *v) {
    v->mouseRelease(event->button);
    return TRUE;
}

/************************************************************************/
gint motion_hnd(GtkWidget          *widget,
		GdkEventMotion     *event,
		GtkGLWidget                *v) {
    v->mouseMotion(event->x, event->y);
    return TRUE;
}
