#ifndef GTKEVENTADAPTER
#define GTKEVENTADAPTER 1

#ifdef WIN32
#  define EXPORT __declspec(dllexport)
#  include <windows.h>
#else
#  define EXPORT
#endif
#include <osgGA/GUIEventAdapter>

/** Class for adapting GLUT events so that they can be used as input to osgUtil::CameraManipulators.*/
class EXPORT GtkEventAdapter : public osgGA::GUIEventAdapter
{

    public:
        GtkEventAdapter();
        virtual ~GtkEventAdapter() {}

        /** Get the EventType of the GUI event.*/
        virtual EventType getEventType() const { return _eventType; }

        /** key pressed, return -1 if inappropriate for this event. */
        virtual int getKey() const { return _key; }

        /** button pressed/released, return -1 if inappropriate for this event.*/
        virtual int getButton() const { return _button; }

        /** window minimum x. */
        virtual float getXmin() const  { return _Xmin; }

        /** window maximum x. */
        virtual float getXmax() const  { return _Xmax; }

        /** window minimum y. */
        virtual float getYmin() const { return _Ymin; }

        /** window maximum y. */
        virtual float getYmax() const { return _Ymax; }

        /** current mouse x position.*/
        virtual float getX() const { return _mx; }

        /** current mouse y position.*/
        virtual float getY() const { return _my; }

        //** current mouse button state *
        virtual unsigned int getButtonMask() const { return _buttonMask; }

        // Unsupported
	virtual unsigned int getModKeyMask() const { return 0; }

        //** time in seconds of event. *
        virtual double time() const { return _time; }

        /*
        // static method for setting window dimensions.*
        static void setWindowSize(int Xmin, int Ymin, int Xmax, int Ymax);
        */
        // static method for setting button state.*
        static void setButtonMask(unsigned int buttonMask);


	void adaptMousePress(float time, int buttonMask, double x, double y);
	void adaptMouseRelease(float time, int buttonMask, double x, double y);
	void adaptMouseMove(float time, int buttonMask, double x, double y);
        void adaptReshape(float time, double width, double height);

        // method for adapting resize events. *
        void adaptResize(float t, int Xmin, int Ymin, int Xmax, int Ymax);

        /*// method for adapting mouse motion events whilst mouse buttons are pressed.*
        void adaptMouseMotion(float t, int x, int y);

        // method for adapting mouse motion events whilst no mouse button are pressed.*
        void adaptMousePassiveMotion(float t,int x, int y);

        // method for adapting mouse button pressed/released events.*
        void adaptMouse(float t,int button, int state, int x, int y);

        // method for adapting keyboard events.*
        void adaptKeyboard(float t,unsigned char key, int x, int y );

        void copyStaticVariables();
        */

        // method for adapting frame events, i.e. idle/display callback.*
        void adaptFrame(float t);
    protected:

        EventType _eventType;
        int _key;
        int _button;
        int _Xmin,_Xmax;
        int _Ymin,_Ymax;
        int _mx;
        int _my;
        unsigned int _buttonMask;
        float _time;


};

#endif
