#include <iostream>
#include "gtkeventadapter.h"


GtkEventAdapter::GtkEventAdapter()
{
    _eventType = NONE;           // adaptor does not encapsulate any events.
    _key = -1;                   // set to 'invalid' key value.
    _button = -1;                // set to 'invalid' button value.
    _mx = -1;                    // set to 'invalid' position value.
    _my = -1;                    // set to 'invalid' position value.
    _buttonMask = 0;             // default to no mouse buttons being pressed.
    _time = 0.0f;                // default to no time has been set.

}

void GtkEventAdapter::setButtonMask(unsigned int buttonMask)
{
}


void GtkEventAdapter::adaptMousePress(float time, int buttonMask, double x, double y) {
    _eventType = PUSH;
    _time = time;
    _mx = (int)x;
    _my = (int)y;
    _buttonMask=buttonMask;
}

void GtkEventAdapter::adaptMouseRelease(float time, int buttonMask, double x, double y) {
    _eventType = RELEASE;
    _time = time;
    _mx = (int)x;
    _my = (int)y;
    _buttonMask=buttonMask;
}

void GtkEventAdapter::adaptMouseMove(float time, int buttonMask, double x, double y) {
    if (buttonMask) {
	_eventType = DRAG;
    } else {
	_eventType = MOVE;
    }
    _time = time;
    _mx = (int)x;
    _my = (int)y;
    _buttonMask=buttonMask;
}

void GtkEventAdapter::adaptReshape(float time, double width, double height) {
}



void GtkEventAdapter::adaptResize(float time, int Xmin, int Ymin, int Xmax, int Ymax)
{
    _Xmin=Xmin;
    _Xmax=Xmax;
    _Ymin=Ymin;
    _Ymax=Ymax;
    _eventType = RESIZE;
    _time = time;
}

void GtkEventAdapter::adaptFrame(float time)
{
    _eventType = FRAME;
    _time = time;
}
