#ifndef __ORTHO_MANIPULATOR_H__
#define __ORTHO_MANIPULATOR_H__

#include <osgGA/CameraManipulator>

class OrthoManipulator: public osgGA::CameraManipulator {
public:
    typedef enum {
	FRONT,
	BACK,
	TOP,
	BOTTOM,
	LEFT,
        RIGHT
    } ViewType;

private:
    osg::Camera *cam;
    float scale;
    ViewType view;
public:
    OrthoManipulator() {
	scale=1.0f;
        view=FRONT;
    }

    virtual void setCamera(osg::Camera* cam) {
	this->cam=cam;
        updateView();
    }
    void setScale(float scale) {
        this->scale=scale;
        if (cam) updateView();
    }
    float getScale() { return scale; }
    virtual bool handle(const osgGA::GUIEventAdapter& ea, osgGA::GUIActionAdapter& us) {
        return false;
    }
    void updateView() {
	switch (view) {
	case FRONT:cam->setLookAt(0,0,-100,  0,0,1,  0,1,0);break;
	case BACK:cam->setLookAt(0,0,100,    0,0,-1, 0,1,0);break;
	case TOP:cam->setLookAt(0,100,0,     0,-1,0, 0,0,1);break;
	case BOTTOM:cam->setLookAt(0,-100,0, 1,0,0,  0,0,-1);break;
	case LEFT:cam->setLookAt(-100,0,0,   1,0,0,  0,1,0);break;
	case RIGHT:cam->setLookAt(100,0,0,  -1,0,0,  0,1,0);break;
	}
	cam->setOrtho2D(-scale,scale,scale,-scale);
//	cam->setUseNearClippingPlane(false);
//	cam->setUseFarClippingPlane(false);
    }
};

#endif
