/*
 * Ficheiro main.c principal xerado por Glade. Edita o que precises.
 * Glade non vai sobreescribir este ficheiro.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

//#define HAVE_GNOME

#ifdef HAVE_GNOME
#include <gnome.h>
#else
#include <gtk/gtk.h>
#include "gui/support.h"
#endif

#include <gui/editorgtk.h>


#include <tool/toolbox.h>
#include <tool/tooldelete.h>
#include <tool/toolundo.h>
#include <tool/toolredo.h>
#include <tool/tooltransform.h>
#include <tool/toolmove.h>
#include <tool/toolorbit.h>
#include <tool/toolpan.h>
#include <tool/toolcopy.h>
#include <tool/toolpaste.h>
#include <tool/toolcut.h>
#include <tool/toolrotate.h>
#include <tool/toolscale.h>
#include <tool/toolzoom.h>
#include <tool/toolnew.h>
#include <tool/toolopen.h>
#include <tool/toolsave.h>
#include <tool/toolsaveas.h>
#include <tool/toolmerge.h>
#include <tool/toolmakesphere.h>
#include <tool/toolmakebox.h>
#include <tool/toolmakecylinder.h>
#include <tool/toolmakecone.h>
#include <tool/toolcenterselection.h>
#include <tool/toolpick.h>
#include <tool/toolmaterial.h>
#include <tool/tooltexture.h>
#include <tool/toolblendfunc.h>
#include <tool/toolcullface.h>
#include <tool/toolfrontface.h>
#include <tool/toollightmodel.h>
#include <tool/toolshademodel.h>
#include <tool/toolfog.h>
#include <tool/toolstateset.h>
#include <tool/tooltexmat.h>
#include <tool/view/toolviewfactory.h>
#include <tool/view/drawingareaview.h>
#include <tool/view/fileselectionview.h>

static void registerTools() {
    osg::ref_ptr<Tool> toolmove=new ToolMove();
    osg::ref_ptr<Tool> toolrotate=new ToolRotate();
    osg::ref_ptr<Tool> toolscale=new ToolScale();
    osg::ref_ptr<Tool> toolopen=new ToolOpen();
    osg::ref_ptr<Tool> toolsave=new ToolSave();
    osg::ref_ptr<Tool> toolsaveas=new ToolSaveAs();
    osg::ref_ptr<Tool> toolmerge=new ToolMerge();
    osg::ref_ptr<Tool> toolorbit=new ToolOrbit();
    osg::ref_ptr<Tool> toolpan=new ToolPan();
    osg::ref_ptr<Tool> toolmakesphere=new ToolMakeSphere();
    osg::ref_ptr<Tool> toolmakebox=new ToolMakeBox();
    osg::ref_ptr<Tool> toolmakecylinder=new ToolMakeCylinder();
    osg::ref_ptr<Tool> toolmakecone=new ToolMakeCone();
    osg::ref_ptr<Tool> toolpick=new ToolPick();

    ToolBox::instance()->registerTool(new ToolDelete());
    ToolBox::instance()->registerTool(new ToolUndo());
    ToolBox::instance()->registerTool(new ToolRedo());
    ToolBox::instance()->registerTool(new ToolTransform());
    ToolBox::instance()->registerTool(toolmove.get());
    ToolBox::instance()->registerTool(toolrotate.get());
    ToolBox::instance()->registerTool(toolscale.get());
    ToolBox::instance()->registerTool(new ToolCopy());
    ToolBox::instance()->registerTool(new ToolPaste());
    ToolBox::instance()->registerTool(new ToolCut());
    ToolBox::instance()->registerTool(new ToolZoomIn());
    ToolBox::instance()->registerTool(new ToolZoomOut());
    ToolBox::instance()->registerTool(new ToolNew());
    ToolBox::instance()->registerTool(toolopen.get());
    ToolBox::instance()->registerTool(toolsave.get());
    ToolBox::instance()->registerTool(toolsaveas.get());
    ToolBox::instance()->registerTool(toolmerge.get());
    ToolBox::instance()->registerTool(toolorbit.get());
    ToolBox::instance()->registerTool(toolpan.get());
    ToolBox::instance()->registerTool(toolmakesphere.get());
    ToolBox::instance()->registerTool(toolmakebox.get());
    ToolBox::instance()->registerTool(toolmakecylinder.get());
    ToolBox::instance()->registerTool(toolmakecone.get());
    ToolBox::instance()->registerTool(new ToolCenterSelection());
    ToolBox::instance()->registerTool(toolpick.get());
    ToolBox::instance()->registerTool(new ToolMaterial());
    ToolBox::instance()->registerTool(new ToolTexture());
    ToolBox::instance()->registerTool(new ToolBlendFunc());
    ToolBox::instance()->registerTool(new ToolCullFace());
    ToolBox::instance()->registerTool(new ToolFrontFace());
    ToolBox::instance()->registerTool(new ToolLightModel());
    ToolBox::instance()->registerTool(new ToolShadeModel());
    ToolBox::instance()->registerTool(new ToolFog());
    ToolBox::instance()->registerTool(new ToolStateSet());
    ToolBox::instance()->registerTool(new ToolTexMat());

    osg::ref_ptr<ToolView> drawingarea=new DrawingAreaView();
    osg::ref_ptr<ToolView> filesel=new FileSelectionView();
    ToolViewFactory::instance()->registerView(toolmove.get(),drawingarea.get());
    ToolViewFactory::instance()->registerView(toolrotate.get(),drawingarea.get());
    ToolViewFactory::instance()->registerView(toolscale.get(),drawingarea.get());
    ToolViewFactory::instance()->registerView(toolopen.get(),filesel.get());
    ToolViewFactory::instance()->registerView(toolsaveas.get(),filesel.get());
    ToolViewFactory::instance()->registerView(toolmerge.get(),filesel.get());
    ToolViewFactory::instance()->registerView(toolorbit.get(),drawingarea.get());
    ToolViewFactory::instance()->registerView(toolpan.get(),drawingarea.get());
    ToolViewFactory::instance()->registerView(toolmakesphere.get(),drawingarea.get());
    ToolViewFactory::instance()->registerView(toolmakebox.get(),drawingarea.get());
    ToolViewFactory::instance()->registerView(toolmakecylinder.get(),drawingarea.get());
    ToolViewFactory::instance()->registerView(toolmakecone.get(),drawingarea.get());
    ToolViewFactory::instance()->registerView(toolpick.get(),drawingarea.get());

}

#include <editable/view/gtkedfactory.h>
#include <editable/attributes/edbool.h>
#include <editable/view/gtkedenum.h>
#include <editable/view/gtkedbool.h>
#include <editable/view/gtkedint.h>
#include <editable/view/gtkedfloat.h>
#include <editable/view/gtkedvec3.h>
#include <editable/view/gtkedcolour.h>
#ifdef HAVE_GNOME
#  include <editable/view/gnomeedcolour.h>
#  include <editable/view/gnomeedfile.h>
#endif
#include <editable/view/gtkedlist.h>
#include <editable/view/gtkedstring.h>
#include <editable/view/gtkedmatrix.h>
#include <editable/view/gtkedreference.h>

static void registerEditors() {
    GtkEdFactory::instance()->registerEditor("bool", new GtkEdBool());
    GtkEdFactory::instance()->registerEditor("enum", new GtkEdEnum());
    GtkEdFactory::instance()->registerEditor("int", new GtkEdInt());
    GtkEdFactory::instance()->registerEditor("float", new GtkEdFloat());
    GtkEdFactory::instance()->registerEditor("Vec3", new GtkEdVec3());
#ifdef HAVE_GNOME
    GtkEdFactory::instance()->registerEditor("Colour", new GnomeEdColour());
    GtkEdFactory::instance()->registerEditor("file", new GnomeEdFile());
#else
    GtkEdFactory::instance()->registerEditor("Colour", new GtkEdColour());
    GtkEdFactory::instance()->registerEditor("file", new GtkEdString());
#endif
    GtkEdFactory::instance()->registerEditor("list", new GtkEdList());
    GtkEdFactory::instance()->registerEditor("string", new GtkEdString());
    GtkEdFactory::instance()->registerEditor("Matrix", new GtkEdMatrix());
    GtkEdFactory::instance()->registerEditor("reference", new GtkEdReference());
    /// FIXME: Create a GtkEdFile, with file navigator...
}

#include <osg/Billboard>
#include <editable/entities/edbillboard.h>
#include <osg/LOD>
#include <editable/entities/edlod.h>
#include <osg/Sequence>
#include <editable/entities/edsequence.h>
#include <osg/Switch>
#include <editable/entities/edswitch.h>
#include <osg/Light>
#include <editable/entities/edlight.h>
#include <osg/ShadeModel>
#include <editable/entities/edshademodel.h>
#include <osg/LightSource>
#include <editable/entities/edlightsource.h>
#include <osg/Material>
#include <editable/entities/edmaterial.h>
#include <osg/Texture>
#include <editable/entities/edtexture.h>
#include <osg/BlendFunc>
#include <editable/entities/edblendfunc.h>
#include <osg/CullFace>
#include <editable/entities/edcullface.h>
#include <osg/FrontFace>
#include <editable/entities/edfrontface.h>
#include <osg/LightModel>
#include <editable/entities/edlightmodel.h>
#include <osg/Fog>
#include <editable/entities/edfog.h>
#include <osg/TexMat>
#include <editable/entities/edtexmat.h>
#include <editable/entities/edstateset.h>
#include <editable/entities/edappconfig.h>
#include <editable/entities/edcfggrid.h>
#include <editable/entities/edcfgview.h>
#include <editable/entityfactory.h>
static void registerEntities() {
    /// Nodes
    EntityFactory::instance()->registerEntity(new osg::Billboard(), new EdBillboard());
    EntityFactory::instance()->registerEntity(new osg::LOD(), new EdLOD());
    EntityFactory::instance()->registerEntity(new osg::Sequence(), new EdSequence());
    EntityFactory::instance()->registerEntity(new osg::Switch(), new EdSwitch());
    EntityFactory::instance()->registerEntity(new osg::LightSource(), new EdLightSource());

    /// The StateSet
    EntityFactory::instance()->registerEntity(new osg::StateSet(), new EdStateSet());

    /// State Attributes
    EntityFactory::instance()->registerEntity(new osg::Light(), new EdLight());
    EntityFactory::instance()->registerEntity(new osg::ShadeModel(), new EdShadeModel());
    EntityFactory::instance()->registerEntity(new osg::Material(), new EdMaterial());
    EntityFactory::instance()->registerEntity(new osg::Texture2D(), new EdTexture());
    EntityFactory::instance()->registerEntity(new osg::BlendFunc(), new EdBlendFunc());
    EntityFactory::instance()->registerEntity(new osg::CullFace(), new EdCullFace());
    EntityFactory::instance()->registerEntity(new osg::FrontFace(), new EdFrontFace());
    EntityFactory::instance()->registerEntity(new osg::LightModel(), new EdLightModel());
    EntityFactory::instance()->registerEntity(new osg::Fog(), new EdFog());
    EntityFactory::instance()->registerEntity(new osg::TexMat(), new EdTexMat());
    EntityFactory::instance()->registerEntity(AppConfig::instance(), new EdAppConfig());
    EntityFactory::instance()->registerEntity(new CfgGrid(), new EdCfgGrid());
    EntityFactory::instance()->registerEntity(new CfgView(), new EdCfgView());
}

int
main (int argc, char *argv[])
{
  GtkWidget *main_window;

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

#ifdef HAVE_GNOME
  gnome_program_init (PACKAGE, VERSION, LIBGNOMEUI_MODULE,
                      argc, argv,
                      GNOME_PARAM_APP_DATADIR, PACKAGE_DATA_DIR,
                      NULL);
#else
  gtk_set_locale ();
  gtk_init (&argc, &argv);
  //add_pixmap_directory (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps");
  add_pixmap_directory (PACKAGE_DATA_DIR "/pixmaps" );
#endif
  registerTools();
  osg::setNotifyLevel(osg::DEBUG_INFO);
  registerEditors();
  registerEntities();
  osg::ref_ptr<Editor> ed=new EditorGTK();
  if (argc > 1) {
      osg::Node *node = ed->getSceneGraph()->loadFile(argv[1]);
      if (node) {
	  ed->getSceneGraph()->replaceScenegraph(node);
	  ed->setLoadedFile(argv[1]);
      }
  }
  gtk_main ();
  return 0;
}

