#include "properties.h"
#include "support.h"
#include <editable/entityfactory.h>
#include <stdio.h>
#include "warning.h"

Properties::Properties(GtkContainer *container) {
    this->container=container;
    this->node_label=gtk_label_new(_("Unknown object"));
    gtk_widget_show(node_label);
    gtk_widget_ref(node_label);
    this->widget_shown=0;
}

Properties::~Properties() {
    gtk_widget_unref(node_label);
}

void Properties::showObject(osg::Object *object) {
    if (widget_shown != 0) {
	gtk_container_remove(container, widget_shown);
        gtk_widget_unref(widget_shown);
    }
    selected=object;

    EditableEntity *editable = EntityFactory::instance()->findEntity(object);
    if (editable != 0) {
	shown = new GtkEntityForm(editable);
	widget_shown=shown->getWidget();
    } else {
        widget_shown=node_label;
    }
    gtk_widget_ref(widget_shown);
    gtk_container_add(container, widget_shown);
}

void Properties::update() {
}
