#ifndef __OSG_TREE_GTK_H__
#define __OSG_TREE_GTK_H__

#include <config.h>
#include <gtk/gtktreestore.h>
#include <gtk/gtktreeselection.h>
#include <osgtreemodel.h>
#include <osg/Node>
#include <vector>

class OsgTreeModelGTK: public OsgTreeModel {
    GtkTreeStore *store;
    GtkTreeSelection *selection;
    typedef std::vector<GtkTreeIter> TreeIterList;
public:
    OsgTreeModelGTK(osg::Node *root=0);
    void setTreeSelection(GtkTreeSelection *sel) { this->selection=sel; }
    void update();
    virtual void addChild(osg::Group *parent, osg::Node *child);
    virtual void removeChild(osg::Group *parent, osg::Node *child);
    virtual void renameNode(osg::Node *node, std::string name);
    GtkTreeModel *getModel() { return GTK_TREE_MODEL(store); }

    // changes the current selection in this tree model
    virtual void select(osg::NodePath &path);
protected:
    GtkTreeIter *findNodePath(osg::NodePath &path, GtkTreeIter *parent);
    void findNode(osg::Node *node, GtkTreeIter *parent, TreeIterList &list);
    void findChild(osg::Node *node, GtkTreeIter *parent, GtkTreeIter *child);
};

#endif
