#include "osgtreemodelgtk.h"

#include <osg/Node>
#include <osg/Group>
#include <osg/Geode>
#include <osg/Transform>
#include <osg/LightSource>
#include <osg/Sequence>
#include <osg/Switch>
#include <osg/LOD>
#include <osg/Billboard>
#include <gui/support.h>

#include <stdio.h>
#include <map>
#include <string>

class BuildTreeStore: public osg::NodeVisitor {
    typedef std::map<std::string,GdkPixbuf*> PixBufMap;
    static PixBufMap pixbufs;
    GtkTreeStore *store;
    GtkTreeIter parent;
    bool isRoot;
    static int namepos;
    void hijos(osg::Group &g, GtkTreeIter newparent) {
	bool b=isRoot;
        isRoot=false;
	GtkTreeIter previousp = parent;
	parent=newparent;
	for (unsigned i=0;i<g.getNumChildren();i++) {
	    osg::Node *n = g.getChild(i);
            n->accept(*this);
	}
	parent=previousp;
        isRoot=b;
    }
    std::string genName(std::string name, std::string type) {
	if (name=="") {
	    char s[1024];
	    sprintf(s,"%s%d",type.c_str(),namepos++);
	    return std::string(s);
	} else {
	    return name;
	}
    }
    GtkTreeIter *getParent() { return isRoot?0:&parent; }
public:
    BuildTreeStore(GtkTreeStore *store, GtkTreeIter *root=0) {
	this->store=store;
	if (root == 0) {
            this->isRoot=true;
	} else {
	    this->isRoot=false;
	    this->parent=*root;
	    osg::NodePath *path=0;
	    gtk_tree_model_get (GTK_TREE_MODEL(store), root, 2, &path, -1);
            _nodePath=*path;

	}
    }

    GdkPixbuf* getPixbuf(std::string s) {
	if (pixbufs.find(s) == pixbufs.end()) {
	    if (s =="geode") {
		pixbufs[s]=create_pixbuf("osgedit/geode.png");
	    } else if (s == "group") {
		pixbufs[s]=create_pixbuf("osgedit/group.png");
	    } else if (s == "lod") {
		pixbufs[s]=create_pixbuf("osgedit/lod.png");
	    } else if (s == "switch") {
		pixbufs[s]=create_pixbuf("osgedit/switch.png");
	    } else if (s == "lightsource") {
		pixbufs[s]=create_pixbuf("osgedit/lightsource.png");
	    } else if (s == "billboard") {
		pixbufs[s]=create_pixbuf("osgedit/billboard.png");
	    } else if (s == "transform") {
		pixbufs[s]=create_pixbuf("osgedit/transform.png");
	    } else if (s == "sequence") {
		pixbufs[s]=create_pixbuf("osgedit/sequence.png");
	    } else pixbufs[s]=create_pixbuf("osgedit/node.png");
	}
	return pixbufs[s];
    }

    GtkTreeIter registerNode(osg::Node &node, std::string type) {
        node.setName(genName(node.getName().c_str(),type));
	char *name=strdup(node.getName().c_str());
        GtkTreeIter iter;
	gtk_tree_store_append(store,&iter,getParent());
	osg::NodePath *node_path=new osg::NodePath(getNodePath()); //LEAK
	gtk_tree_store_set(store,&iter,0,name,1,&node,2,node_path,3,getPixbuf(type),-1);
        return iter;
    }

    virtual void apply(osg::Node& node) {
        registerNode(node,"unknown");
    }
    virtual void apply(osg::Geode& node) {
        registerNode(node,"geode");
    }
    virtual void apply(osg::LightSource& node) {
        registerNode(node,"lightsource");
    }
    virtual void apply(osg::Group& node) {
        GtkTreeIter iter=registerNode(node,"group");
        hijos(node,iter);
    }
    virtual void apply(osg::Switch& node) {
        GtkTreeIter iter=registerNode(node,"switch");
	hijos(node,iter);
    }
    virtual void apply(osg::Sequence& node) {
        GtkTreeIter iter=registerNode(node,"sequence");
	hijos(node,iter);
    }
    virtual void apply(osg::Transform& node) {
        GtkTreeIter iter=registerNode(node,"transform");
        hijos(node,iter);
    }
    virtual void apply(osg::LOD& node) {
        GtkTreeIter iter=registerNode(node,"lod");
	hijos(node,iter);
    }
    virtual void apply(osg::Billboard& node) {
        registerNode(node,"billboard");
    }
};

int BuildTreeStore::namepos=0;
BuildTreeStore::PixBufMap BuildTreeStore::pixbufs;

OsgTreeModelGTK::OsgTreeModelGTK(osg::Node *root): OsgTreeModel(root) {
    this->store=gtk_tree_store_new(4,G_TYPE_STRING,G_TYPE_POINTER,G_TYPE_POINTER,GDK_TYPE_PIXBUF);
    selection=0;
    update();
}

void OsgTreeModelGTK::update() {
    gtk_tree_store_clear(store);
    if (root != 0) {
	osg::ref_ptr<BuildTreeStore> builder = new BuildTreeStore(store);
	root->accept(*builder.get());
    }
}

void OsgTreeModelGTK::findNode(osg::Node *node, GtkTreeIter *parent, TreeIterList &list) {
    unsigned children=gtk_tree_model_iter_n_children(GTK_TREE_MODEL(store),parent);
    osg::Node *parentNode=0;
    gtk_tree_model_get(GTK_TREE_MODEL(store),parent,1,&parentNode,-1);
    if (parentNode==node) {
        list.push_back(*parent);
    } else {
	for (unsigned i=0;i<children;i++) {
	    GtkTreeIter child;
	    gtk_tree_model_iter_nth_child(GTK_TREE_MODEL(store),&child,parent,i);
            findNode(node,&child,list);
	}
    }
}

void OsgTreeModelGTK::findChild(osg::Node *node, GtkTreeIter *parent, GtkTreeIter *_child) {
    unsigned children=gtk_tree_model_iter_n_children(GTK_TREE_MODEL(store),parent);
    osg::Node *parentNode=0;
    for (unsigned i=0;i<children;i++) {
	GtkTreeIter child;
	gtk_tree_model_iter_nth_child(GTK_TREE_MODEL(store),&child,parent,i);
	gtk_tree_model_get(GTK_TREE_MODEL(store),&child,1,&parentNode,-1);
	if (parentNode==node) {
	    *_child=child;
	}
    }
}


void OsgTreeModelGTK::addChild(osg::Group *parent, osg::Node *child) {
    GtkTreeIter parentIter;
    gtk_tree_model_get_iter_root(GTK_TREE_MODEL(store),&parentIter);
    TreeIterList list;
    findNode(parent,&parentIter,list);
    for (unsigned i=0;i<list.size();i++) {
	GtkTreeIter iter=list[i];
	osg::ref_ptr<BuildTreeStore> builder = new BuildTreeStore(store,&iter);
	child->accept(*builder.get());
    }
}

void OsgTreeModelGTK::removeChild(osg::Group *parent, osg::Node *child) {
    GtkTreeIter parentIter;
    gtk_tree_model_get_iter_root(GTK_TREE_MODEL(store),&parentIter);
    TreeIterList list;
    findNode(parent,&parentIter,list);
    for (unsigned i=0;i<list.size();i++) {
	GtkTreeIter iter=list[i];
	GtkTreeIter theChild;
	findChild(child,&iter,&theChild);
	gtk_tree_store_remove(store,&theChild);
    }
}

void OsgTreeModelGTK::renameNode(osg::Node *node, std::string name) {
    GtkTreeIter iter;
    gtk_tree_model_get_iter_root(GTK_TREE_MODEL(store),&iter);
    TreeIterList list;
    findNode(node,&iter,list);
    for (unsigned i=0;i<list.size();i++) {
	iter=list[i];
	char *name=strdup(node->getName().c_str());
	gtk_tree_store_set(store,&iter,0,name,-1);
    }
}

GtkTreeIter *OsgTreeModelGTK::findNodePath(osg::NodePath &path, GtkTreeIter *parent) {
    unsigned children=gtk_tree_model_iter_n_children(GTK_TREE_MODEL(store),parent);
    osg::NodePath *curpath=0;
    gtk_tree_model_get (GTK_TREE_MODEL(store), parent, 2, &curpath, -1);
    if (*curpath==path) {
	return parent;
    } else {
	for (unsigned i=0;i<children;i++) {
	    GtkTreeIter child;
	    gtk_tree_model_iter_nth_child(GTK_TREE_MODEL(store),&child,parent,i);
	    GtkTreeIter *it = findNodePath(path,&child);
            if (it!=0) return it;
	}
        return 0;
    }
}

void OsgTreeModelGTK::select(osg::NodePath &path) {
    if (selection != 0) {
	GtkTreeIter iter;
	gtk_tree_model_get_iter_root(GTK_TREE_MODEL(store),&iter);
        gtk_tree_selection_select_iter(selection, findNodePath(path, &iter));
    } else {
	std::cout << "FATAL ERROR: OsgTreeModelGTK::selection is NULL!!!" << std::endl;
    }
}
