#ifndef __EDITOR_GTK_H__
#define __EDITOR_GTK_H__

#include <config.h>
#include <editor.h>
#include <gtk/gtkwidget.h>
#include <gtkviewer.h>
#include <tool/view/drawingareaview.h>
#include "properties.h"

/** @class EditorGTK
 * @brief Concrete Editor implemented using the GTK/GNOME widgets set.
 */
class EditorGTK: public Editor {
    GtkWidget *window;
    GtkViewer *viewer;
    osg::ref_ptr<DrawingAreaView> drawingArea; ///< We need to notify this for clicks and mouse movements
    osg::ref_ptr<Properties> properties;
    unsigned timeout_hnd;
    bool already_selecting;
public:
    EditorGTK();
    void registerDrawingAreaView(DrawingAreaView *v);
    void mouseMoved(float x, float y);
    void mousePressed();
    void mouseReleased();

    virtual void executed(Command *c);
    virtual void unexecuted(Command *c);

    void redisplay();
    virtual void finalize(); // frees some GTK resources

    // Some ugly stuff to avoid infinite recursion when selecting
    bool getSelecting() { return already_selecting; }
    void setSelecting(bool b) { already_selecting = b; }

    virtual void editObject(osg::Object *);
private:
    void config_treeview(GtkTreeView *tv);
    void config_ranges(GtkTreeView *tv);
    void config_switch(GtkTreeView *tv);
protected:
    virtual void selected(osg::Node *node, osg::NodePath &path);

};

#endif
