#include <config.h>
#include <tool/tool.h>
#include "editorgtk.h"
#include "interface.h"
#include <local.h>
#include "gui/support.h"
#include "osgtreemodelgtk.h"
#include <osgGA/CameraManipulator>
#include <command/comrename.h>


#define EDITOR(w) ((Editor*)g_object_get_data(G_OBJECT(lookup_widget(GTK_WIDGET(w),"main_window")),"class"))

static gboolean timeout(void *data) {
    //GtkViewer *viewer=(GtkViewer *)data;
    //viewer->display();
    EditorGTK *editor = (EditorGTK*)data;
    editor->redisplay();
    return TRUE;
}


class NullManipulator: public osgGA::CameraManipulator {
private:
    float ancho,alto;
    EditorGTK *editor;
public:
    NullManipulator(EditorGTK *e) { editor=e; }
    virtual bool handle(const osgGA::GUIEventAdapter& ea, osgGA::GUIActionAdapter& us) {
	switch (ea.getEventType()) {
	case osgGA::GUIEventAdapter::RESIZE:{
	    ancho=ea.getXmax();
	    alto=ea.getYmax();
	    return true;
	} break;
	case osgGA::GUIEventAdapter::PUSH:{
	    editor->mousePressed();
	}break;
	case osgGA::GUIEventAdapter::RELEASE:{
	    editor->mouseReleased();
	}break;
	case osgGA::GUIEventAdapter::MOVE:
        case osgGA::GUIEventAdapter::DRAG:{
	    float px=ea.getX()/(float)ancho;
	    float py=1-ea.getY()/(float)alto;
	    editor->mouseMoved(px,py);
	}break;
	default:
	    return false;
	}
	return false;
    }
};

static void
tree_selection_changed_cb (GtkTreeSelection *selection, gpointer data)
{
    EditorGTK *editor = (EditorGTK*)data;

    GtkTreeIter iter;
    GtkTreeModel *model;
    osg::Node *node=0;
    if (gtk_tree_selection_get_selected (selection, &model, &iter))
    {
	//osg::Group *parent=0;
	osg::NodePath *path;
	GtkTreeIter parentiter;
	gtk_tree_model_get (model, &iter, 1, &node, 2, &path, -1);
	/*
	if (gtk_tree_model_iter_parent(model,&parentiter,&iter)) {
	    gtk_tree_model_get(model,&parentiter,1,&parent,-1);
	}
	editor->selectNode(node,parent);
	*/
        // Trick to avoid infinite recursion
	if (!editor->getSelecting()) {
            editor->setSelecting(true);
	    editor->selectNode(node,*path, false);
            editor->setSelecting(false);
	}
    }
}


static void
renderer_edited(GtkCellRendererText *cellrenderertext,
		gchar *arg1,
		gchar *arg2,
		gpointer user_data) {
    Editor *editor = (Editor*)user_data;

    if (strcmp(editor->getSelected()->getName().c_str(),arg2)!=0) {
	osg::ref_ptr<ComRename> com = new ComRename(editor->getSelected(),arg2,editor->getSceneGraph());
	com->execute();
    }
}

void EditorGTK::config_treeview(GtkTreeView *tv) {
    GtkCellRenderer *renderer;
    GtkTreeViewColumn *column;


    renderer = gtk_cell_renderer_pixbuf_new();
    column = gtk_tree_view_column_new_with_attributes (_("Type"),
						       renderer,
						       "pixbuf", 3,
                                                       NULL);
    gtk_tree_view_append_column(tv,column);

    renderer = gtk_cell_renderer_text_new ();
    g_signal_connect(G_OBJECT(renderer),"edited",
                     G_CALLBACK(renderer_edited),this);
    g_object_set(G_OBJECT(renderer),"editable",TRUE,0);
    column = gtk_tree_view_column_new_with_attributes (_("Name"),
						       renderer,
						       "text", 0,
						       NULL);
    gtk_tree_view_append_column (tv, column);

    GtkTreeSelection *select;

    select = gtk_tree_view_get_selection (GTK_TREE_VIEW (tv));
    //gtk_tree_selection_set_mode (select, GTK_SELECT_SINGLE);
    g_signal_connect (G_OBJECT (select), "changed",
		      G_CALLBACK (tree_selection_changed_cb),this);

}

EditorGTK::EditorGTK() {
    window=create_main_window();
    gtk_widget_show (window);
    g_object_set_data(G_OBJECT(window),"class",this);

    GtkTreeView *tv = GTK_TREE_VIEW(lookup_widget(window,"scenegraph"));
    OsgTreeModelGTK *treeModel = new OsgTreeModelGTK();
    treeModel->setTreeSelection(gtk_tree_view_get_selection(tv));
    config_treeview(tv);
    gtk_tree_view_set_model(tv,treeModel->getModel());
    sceneGraph->setTreeModel(treeModel);
    GtkContainer *view = GTK_CONTAINER(lookup_widget(window,"views"));
    viewer=new GtkViewer();
    getCameraView()->setData(sceneGraph->getRealRoot());
    viewer->addViewport(getCameraView()->getSceneView());
    viewer->registerCameraManipulator(new NullManipulator(this));
    viewer->open();
    //FIXME: Editor::instance()->setProperties(new Properties(GTK_NOTEBOOK(lookup_widget(main_window,"properties"))));
    gtk_container_add(view,viewer->getWidget());
    properties=new Properties(GTK_CONTAINER(lookup_widget(window,"properties_viewport")));
    timeout_hnd=gtk_timeout_add(50,timeout,this);
    already_selecting=0;
}

void EditorGTK::registerDrawingAreaView(DrawingAreaView *v) {
    drawingArea=v;
}

void EditorGTK::mouseMoved(float x, float y) {
    if (drawingArea.valid()) {
	drawingArea->mouseMoved(x,y);
    }
}

void EditorGTK::mousePressed() {
    if (drawingArea.valid()) {
	drawingArea->mousePressed();
    }
}

void EditorGTK::mouseReleased() {
    if (drawingArea.valid()) {
	drawingArea->mouseReleased();
    }
}
void EditorGTK::selected(osg::Node *node, osg::NodePath &path) {
    if (node!=0) {
	properties->showObject(node);
    }
}

void EditorGTK::executed(Command *c) {
    properties->update();
}

void EditorGTK::unexecuted(Command *c) {
    properties->update();
}

void EditorGTK::redisplay() {
    sceneGraph->recalculateSelection();
    viewer->display();
}

void EditorGTK::finalize() {
    gtk_timeout_remove(timeout_hnd);
}

void EditorGTK::editObject(osg::Object *object) {
    properties->showObject(object);
}
