#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <appconfig.h>
#include <gtk/gtkwindow.h>

#ifdef HAVE_GNOME
#include <gnome.h>
#else
#include <gtk/gtk.h>
#endif
#include <stdlib.h>
#include <iostream>
#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include <scenegraph.h>
#include <editor.h>
#include <command/comaddchild.h>
#include <command/comactivechild.h>
#include <command/comtransformmatrix.h>
#include <command/comlightsource.h>
#include <command/combillboard.h>
#include <command/comlod.h>
#include "warning.h"
#include <osg/Switch>
#include <osg/LOD>
#include <osg/LightSource>
#include <osg/Billboard>
#include <osg/Sequence>

#include <editable/view/gtkentityform.h>
#include <editable/entityfactory.h>


#define EDITOR(w) ((Editor*)g_object_get_data(G_OBJECT(lookup_widget(GTK_WIDGET(w),"main_window")),"class"))

void
on_new1_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->useTool("new");
}


void
on_open1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->useTool("open");
}


void
on_save1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    if (strcmp(EDITOR(menuitem)->getLoadedFile(),"") != 0) {
	EDITOR(menuitem)->useTool("save");
    } else {
        EDITOR(menuitem)->useTool("save_as");
    }
}


void
on_save_as1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->useTool("save_as");
}


void
on_quit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->finalize();
    gtk_main_quit();
}


void
on_cut1_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->useTool("cut");
}


void
on_copy1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->useTool("copy");
}


void
on_paste1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->useTool("paste");
}


void
on_clear1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->useTool("delete");
}


void
on_properties1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_preferences1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    /// TO-DO: Make a Preferences class which know when to destroy itself
    GtkWidget *window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    EditableEntity *editable = EntityFactory::instance()->findEntity(AppConfig::instance());
    if (editable != 0) {
        /// Memory Leak
	GtkEntityForm *shown = new GtkEntityForm(editable);
        gtk_container_add(GTK_CONTAINER(window), shown->getWidget());
    }
    gtk_widget_show_all(window);
}


void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    gtk_widget_show_all(create_about_window());
}


void
on_new_clicked                         (GtkButton       *button,
                                        gpointer         user_data)
{
    EDITOR(button)->useTool("new");
}


void
on_open_clicked                        (GtkButton       *button,
                                        gpointer         user_data)
{
    EDITOR(button)->useTool("open");
}


void
on_save_clicked                        (GtkButton       *button,
                                        gpointer         user_data)
{
    if (strcmp(EDITOR(button)->getLoadedFile(),"") != 0) {
	EDITOR(button)->useTool("save");
    } else {
        EDITOR(button)->useTool("save_as");
    }
}


gboolean
on_scenegraph_key_press_event          (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
    return FALSE;
}


void
on_undo_clicked                        (GtkButton       *button,
                                        gpointer         user_data)
{
    EDITOR(button)->useTool("undo");
}


void
on_redo_clicked                        (GtkButton       *button,
                                        gpointer         user_data)
{
    EDITOR(button)->useTool("redo");
}


void
on_delete_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
    EDITOR(button)->useTool("delete");
}


void
on_addTransform_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
    EDITOR(button)->useTool("transform");
}


gboolean
on_main_window_delete_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    EDITOR(widget)->finalize();
    gtk_main_quit();
    return TRUE;
}


void
on_zoom_in1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->useTool("zoom_in");
}


void
on_zoom_out1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->useTool("zoom_out");
}


void
on_move_clicked                        (GtkButton       *button,
                                        gpointer         user_data)
{
    EDITOR(button)->useTool("move");
}


void
on_rotate_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
    EDITOR(button)->useTool("rotate");
}


void
on_scale_clicked                       (GtkButton       *button,
                                        gpointer         user_data)
{
    EDITOR(button)->useTool("scale");
}


void
on_zoom_in_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
    EDITOR(button)->useTool("zoom_in");
}


void
on_zoom_out_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
    EDITOR(button)->useTool("zoom_out");
}


void
on_front1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->getCameraView()->setViewType(CameraView::FRONT);
}


void
on_back1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->getCameraView()->setViewType(CameraView::BACK);
}


void
on_left1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->getCameraView()->setViewType(CameraView::LEFT);
}


void
on_right1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->getCameraView()->setViewType(CameraView::RIGHT);
}


void
on_top1_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->getCameraView()->setViewType(CameraView::TOP);
}


void
on_bottom1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->getCameraView()->setViewType(CameraView::BOTTOM);
}


void
on_perspective1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->getCameraView()->setViewType(CameraView::USER);
}

void
on_merge1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->useTool("merge");
}


gboolean
on_warning_dialog_delete_event         (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


void
on_ok_warning_dialog_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget *dlg=lookup_widget(GTK_WIDGET(button),"warning_dialog");
    gtk_widget_destroy(dlg);
}

void
on_group1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    osg::Group *editor = dynamic_cast<osg::Group*>(EDITOR(menuitem)->getSelected());
    if (editor!=0) {
	osg::ref_ptr<ComAddChild> com = new ComAddChild(new osg::Group(),editor,EDITOR(menuitem)->getSceneGraph());
        com->execute();
    } else {
        my_warning(_("Can only insert nodes into groups"));
    }
}


void
on_transform1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    osg::Group *editor = dynamic_cast<osg::Group*>(EDITOR(menuitem)->getSelected());
    if (editor!=0) {
	osg::ref_ptr<ComAddChild> com = new ComAddChild(new osg::Transform(),editor,EDITOR(menuitem)->getSceneGraph());
        com->execute();
    } else {
        my_warning(_("Can only insert nodes into groups"));
    }
}


void
on_switch1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    osg::Group *editor = dynamic_cast<osg::Group*>(EDITOR(menuitem)->getSelected());
    if (editor!=0) {
	osg::ref_ptr<ComAddChild> com = new ComAddChild(new osg::Switch(),editor,EDITOR(menuitem)->getSceneGraph());
        com->execute();
    } else {
        my_warning(_("Can only insert nodes into groups"));
    }
}


void
on_lod1_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    osg::Group *editor = dynamic_cast<osg::Group*>(EDITOR(menuitem)->getSelected());
    if (editor!=0) {
	osg::ref_ptr<ComAddChild> com = new ComAddChild(new osg::LOD(),editor,EDITOR(menuitem)->getSceneGraph());
        com->execute();
    } else {
        my_warning(_("Can only insert nodes into groups"));
    }
}



void
on_icons1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    gtk_toolbar_set_style(GTK_TOOLBAR(lookup_widget(GTK_WIDGET(menuitem),"toolbar")),GTK_TOOLBAR_ICONS);
}


void
on_icons_and_text1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    gtk_toolbar_set_style(GTK_TOOLBAR(lookup_widget(GTK_WIDGET(menuitem),"toolbar")),GTK_TOOLBAR_BOTH);
}



void
on_solid1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->getSceneGraph()->setPolygonMode(osg::PolygonMode::FILL);
}


void
on_wireframe1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->getSceneGraph()->setPolygonMode(osg::PolygonMode::LINE);
}


void
on_flat1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->getSceneGraph()->setShadeModel(osg::ShadeModel::FLAT);
}


void
on_smooth1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->getSceneGraph()->setShadeModel(osg::ShadeModel::SMOOTH);
}


void
on_light_node1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    osg::Group *editor = dynamic_cast<osg::Group*>(EDITOR(menuitem)->getSelected());
    if (editor!=0) {
	osg::ref_ptr<ComAddChild> com = new ComAddChild(new osg::LightSource(),editor,EDITOR(menuitem)->getSceneGraph());
        com->execute();
    } else {
        my_warning(_("Can only insert nodes into groups"));
    }
}


void
on_billboard_node1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    osg::Group *editor = dynamic_cast<osg::Group*>(EDITOR(menuitem)->getSelected());
    if (editor!=0) {
	osg::ref_ptr<ComAddChild> com = new ComAddChild(new osg::Billboard(),editor,EDITOR(menuitem)->getSceneGraph());
        com->execute();
    } else {
        my_warning(_("Can only insert nodes into groups"));
    }
}

gboolean
on_material_edit_delete_event          (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


void
on_material1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->useTool("material");
}


gboolean
on_texture_edit_delete_event           (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

    return FALSE;
}


void
on_texture1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->useTool("texture");
}


void
on_orbit_clicked                       (GtkButton       *button,
                                        gpointer         user_data)
{
    EDITOR(button)->useTool("orbit");
}


void
on_orthogonal1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->getCameraView()->setProjectionType(CameraView::ORTHOGONAL);
}


void
on_perspective2_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->getCameraView()->setProjectionType(CameraView::PERSPECTIVE);
}


void
on_undo_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->useTool("undo");
}


void
on_redo_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->useTool("redo");
}


void
on_pan_clicked                         (GtkButton       *button,
                                        gpointer         user_data)
{
    EDITOR(button)->useTool("pan");
}


void
on_sphere1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->useTool("make-sphere");
}


void
on_box1_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->useTool("make-box");
}


void
on_cone1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->useTool("make-cone");
}


void
on_cylinder1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->useTool("make-cylinder");
}


void
on_do_sphere_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
    EDITOR(button)->useTool("make-sphere");
}


void
on_do_box_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
    EDITOR(button)->useTool("make-box");
}


void
on_do_cone_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
    EDITOR(button)->useTool("make-cone");
}


void
on_do_cylinder_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
    EDITOR(button)->useTool("make-cylinder");
}


void
on_center_selection_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
    EDITOR(button)->useTool("center-selection");
}


void
on_center_selection1_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->useTool("center-selection");
}


void
on_select_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
    EDITOR(button)->useTool("pick");
}


void
on_select1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->useTool("pick");
}


void
on_orbit1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->useTool("orbit");
}


void
on_pan1_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->useTool("pan");
}


void
on_move1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->useTool("move");
}


void
on_rotate1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->useTool("rotate");
}


void
on_scale1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->useTool("scale");
}


void
on_sequence1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    osg::Group *editor = dynamic_cast<osg::Group*>(EDITOR(menuitem)->getSelected());
    if (editor!=0) {
	osg::ref_ptr<ComAddChild> com = new ComAddChild(new osg::Sequence(),editor,EDITOR(menuitem)->getSceneGraph());
        com->execute();
    } else {
        my_warning(_("Can only insert nodes into groups"));
    }

}


void
on_blend_function1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->useTool("blend_func");
}


void
on_cull_face1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->useTool("cull_face");
}


void
on_front_face1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->useTool("front_face");
}


void
on_light_model1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->useTool("light_model");
}


void
on_shade_model1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->useTool("shade_model");
}


void
on_fog1_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->useTool("fog");
}


void
on_state_set1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->useTool("state_set");
}


void
on_texture_matrix1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    EDITOR(menuitem)->useTool("texmat");
}

