#include <config.h>
#include "editor.h"
#include <tool/tool.h>
#include <gui/warning.h>
#include <local.h>
#include <tool/toolbox.h>
#include <tool/view/toolviewfactory.h>

Editor::Editor() {
    activeTool=0;
    view=new CameraView();
    sceneGraph=new SceneGraph();
    view->setGridNode(sceneGraph->getGridNode());
    view->setViewType(CameraView::FRONT);
    History::addObserver(this);
}

void Editor::useTool(char *toolname) {
    Tool *tool = ToolBox::instance()->getTool(toolname);
    if (tool) {
	activeTool=tool;
	activeTool->setEditor(this);
	ToolView *tv=ToolViewFactory::instance()->getView(tool);
	if (tv!=0) {
	    tv->setEditor(this);
	    tv->setActiveTool(tool);
            tv->enable();
	}
	try {
	    activeTool->init();
	    if (selectedNode.valid()) {
		activeTool->selected(selectedNode.get(),selectedParent.get());
	    }
	} catch (const char *s) {
            my_warning(s);
            activeTool=0;
	}
    } else {
	std::cerr << "No such tool: " << toolname << std::endl;
	my_warning(_("FATAL ERROR: called an unknown tool"));
    }
}

void Editor::selectNode(osg::Node *node, osg::NodePath &path, bool notifyUI) {
    this->selectedNode=node;
    if (path.size() > 1) {
	osg::Node *node = path[path.size()-2];
	selectedParent = dynamic_cast<osg::Group*>(node);
    } else {
        selectedParent = 0;
    }
    selected(node,path);
    sceneGraph->selectNodePath(path, notifyUI);
    /*FIXME:
     if (selectedNode.valid() && properties.valid()) {
        properties->showNode(selectedNode.get());
	}*/

    /* Can't use the tool now, because GTK gets mad if I change the
     treeview from the selection callback :(
     */
}

std::string Editor::getLoadedFilePath() {
    unsigned pos = loaded_file.rfind('/');
    if (pos != std::string::npos) { // There is a slash
	return std::string(loaded_file,0,pos);
    } else {
        return ".";
    }
}
