#ifndef __GTK_ENTITY_FORM_H__
#define __GTK_ENTITY_FORM_H__

#include "gtkwidgetwrap.h"
#include "gtkedattribute.h"
#include <editable/editableentity.h>

/** @class GtkEntityForm
 * @brief GTK widget containing a form to edit some entity
 */
class GtkEntityForm: public GtkWidgetWrap {
public:
    GtkEntityForm(EditableEntity *editable);
    virtual GtkWidget *getWidget() { return widget; }

    void signal_ok();
    void signal_cancel();
private:
    GtkWidget *widget;
    osg::ref_ptr<EditableEntity> editable;

    /** We need this list to keep references to the active editors and
     * implicitly delete them when the form is closed */
    EditorList attribute_editors;
};

#endif
