#include <gtk/gtkvbox.h>
#include <gtk/gtkhbox.h>
#include <gtk/gtktable.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkframe.h>
#include <gtk/gtkbutton.h>
#include <gtk/gtkeventbox.h>
#include <gtk/gtktooltips.h>
#include "gtkentityform.h"
#include "gtkedfactory.h"

#define VERTICAL_SPACING 0
#define HORIZONTAL_SPACING 3

static void
on_ok_clicked                     (GtkButton       *button,
				   GtkEntityForm *form)
{
    form->signal_ok();
}

static void
on_cancel_clicked                     (GtkButton       *button,
				       GtkEntityForm *form)
{
    form->signal_cancel();
}



GtkEntityForm::GtkEntityForm(EditableEntity *_editable):
    editable(_editable)
{
    GtkTooltips *tooltips;
    tooltips = gtk_tooltips_new ();

    widget = gtk_frame_new (editable->getName().c_str());
    gtk_container_set_border_width (GTK_CONTAINER (widget), 5);

    GtkWidget *vbox = gtk_vbox_new(FALSE,0);
    gtk_container_add (GTK_CONTAINER (widget), vbox);

    EditableAttributeList attributes = editable->getAttributes();
    EditableAttributeList::const_iterator iter;
    GtkWidget *editables = gtk_table_new (3, 2, FALSE);
    gtk_container_add (GTK_CONTAINER (vbox), editables);
    unsigned row=0;
    for (iter=attributes.begin(); iter!=attributes.end(); iter++) {
	osg::ref_ptr<EditableAttribute> attribute = *iter;
	GtkWidget *eventbox = gtk_event_box_new (); // To have tooltips
	GtkWidget *label = gtk_label_new (attribute->getName().c_str());
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
	gtk_container_add (GTK_CONTAINER (eventbox), label);
	gtk_tooltips_set_tip (tooltips, eventbox, attribute->getDescription().c_str(), NULL);
	GtkEdAttribute *editor = GtkEdFactory::instance()->find(attribute.get());
        attribute_editors.push_back(editor);
	editor->build();
        editor->setAttribute(attribute.get());
	GtkWidget *editor_widget=editor->getWidget();
	if (editor->needsLabel()) {
	    gtk_table_attach (GTK_TABLE (editables), eventbox, 0, 1, row, row+1,
			      (GtkAttachOptions) (GTK_FILL),
			      (GtkAttachOptions) (0), 5, 5);
	    gtk_table_attach (GTK_TABLE (editables), editor_widget, 1, 2, row, row+1,
			      (GtkAttachOptions) (GTK_FILL),
			      (GtkAttachOptions) (0), 5, 5);
	} else {
	    gtk_table_attach (GTK_TABLE (editables), editor_widget, 0, 2, row, row+1,
			      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			      5, 5);
	}
        row++;
    }

    GtkWidget *hbox2 = gtk_hbox_new (TRUE, 0);
    gtk_box_pack_start (GTK_BOX (vbox), hbox2, FALSE, TRUE, 5);

    GtkWidget *button1 = gtk_button_new_from_stock ("gtk-ok");
    gtk_box_pack_end (GTK_BOX (hbox2), button1, FALSE, TRUE, 5);
    g_signal_connect ((gpointer) button1, "clicked",
		      G_CALLBACK (on_ok_clicked),
		      this);

    GtkWidget *button2 = gtk_button_new_from_stock ("gtk-cancel");
    gtk_box_pack_end (GTK_BOX (hbox2), button2, FALSE, TRUE, 5);
    g_signal_connect ((gpointer) button2, "clicked",
		      G_CALLBACK (on_cancel_clicked),
		      this);

    gtk_widget_show_all(widget);
}


void GtkEntityForm::signal_ok() {
    editable->commit();
}

void GtkEntityForm::signal_cancel() {

}

