#include <iostream>
#include <gtk/gtkframe.h>
#include <gtk/gtktable.h>
#include <gtk/gtkspinbutton.h>
#include <gtk/gtklabel.h>
#include "gtkedvec3.h"

static void on_adjustmentX_changed (GtkAdjustment *adjustment,
				   GtkEdVec3 *editor) {
    editor->signal_changed(0);
}
static void on_adjustmentY_changed (GtkAdjustment *adjustment,
				   GtkEdVec3 *editor) {
    editor->signal_changed(1);
}
static void on_adjustmentZ_changed (GtkAdjustment *adjustment,
				   GtkEdVec3 *editor) {
    editor->signal_changed(2);
}

void GtkEdVec3::setAttribute(EditableAttribute *attrib) {
    static void* handlers[3]={
	(void*)on_adjustmentX_changed,
	(void*)on_adjustmentY_changed,
	(void*)on_adjustmentZ_changed
    };
    attribute=dynamic_cast<EdVec3*>(attrib);
    if (!attribute.valid()) {
	std::cerr << "GtkEdVec3::build: FATAL ERROR: argument isn't an EdVec3" << std::endl;
        throw -1;
    }

    if (widget ==0 ) {
	std::cerr << "setAttribute MUST be called after build()" << std::endl;
	throw -1;
    }
    if (handler_assigned) {
	for (unsigned i=0;i<3;i++) {
	    g_signal_handler_disconnect((gpointer) spin[i], handler_id[i]);
	}
    }
    for (unsigned i=0;i<3;i++) {
        gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin[i]), (gdouble)attribute->get()[i]);
	handler_id[i] = g_signal_connect ((gpointer) spin[i], "changed",
					  G_CALLBACK (handlers[i]),
					  this);
    }
    handler_assigned=true;
    gtk_frame_set_label (GTK_FRAME (widget), attribute->getName().c_str());
}

void GtkEdVec3::build() {
    static char* labels[3]={
	"X:",
	"Y:",
	"Z:"
    };
    widget = gtk_frame_new (NULL);
    GtkWidget *table = gtk_table_new (3, 2, FALSE);
    gtk_container_set_border_width (GTK_CONTAINER (table), 5);
    gtk_container_add(GTK_CONTAINER(widget), table);
    for (unsigned i=0;i<3;i++) {
	GtkWidget *label = gtk_label_new (labels[i]);
	gtk_table_attach (GTK_TABLE (table), label, 0, 1, i, i+1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 5, 5);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
	GtkObject *widget_adj = gtk_adjustment_new (0,
						    -G_MAXFLOAT,
						    G_MAXFLOAT, 1, 10, 10);
	spin[i] = gtk_spin_button_new (GTK_ADJUSTMENT (widget_adj), 1, 4);
	gtk_table_attach (GTK_TABLE (table), spin[i], 1, 2, i, i+1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 5, 5);
    }
    gtk_widget_ref(widget);
}

GtkEdVec3::GtkEdVec3() {
    widget=0;
    handler_assigned=false;
}

GtkEdVec3::~GtkEdVec3() {
    if (widget!=0) gtk_widget_unref(widget);
}

void GtkEdVec3::signal_changed(int i) {
    osg::Vec3 v = attribute->get();
    GtkAdjustment *widget_adj=gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(spin[i]));
    v[i]=gtk_adjustment_get_value(GTK_ADJUSTMENT(widget_adj));
    attribute->set(v);
}
