#include <iostream>
#include <gtk/gtkspinbutton.h>
#include "gtkedstring.h"

static void on_changed(GtkEditable     *editable,
		       GtkEdString *editor) {
    editor->signal_changed();
}

void GtkEdString::setAttribute(EditableAttribute *attrib) {
    if (widget ==0 ) {
	std::cerr << "setAttribute MUST be called after build()" << std::endl;
	throw -1;
    }
    attribute = dynamic_cast<EdString*>(attrib);
    if (!attribute.valid()) {
	std::cerr << "GtkEdString::build: FATAL ERROR: argument isn't an EdString" << std::endl;
        throw -1;
    }
    if (handler_id != 0xFFFFFFFF) {
        g_signal_handler_disconnect((gpointer) widget, handler_id);
    }
    gtk_entry_set_text(GTK_ENTRY(widget),attribute->get().c_str());

    handler_id = g_signal_connect ((gpointer) widget, "changed",
				   G_CALLBACK (on_changed),
				   this);
}

void GtkEdString::build() {
    widget = gtk_entry_new ();
 
    gtk_widget_ref(widget);
}

GtkEdString::GtkEdString() {
    widget=0;
    handler_id=0xFFFFFFFF;
}

GtkEdString::~GtkEdString() {
    if (handler_id != 0xFFFFFFFF) {
        g_signal_handler_disconnect((gpointer) widget, handler_id);
    }
    if (widget!=0) gtk_widget_unref(widget);
}

void GtkEdString::signal_changed() {
    if (attribute.valid()) {
	attribute->set(gtk_entry_get_text(GTK_ENTRY(widget)));
    }
}
