#ifndef __GTK_ED_REFERENCE_H__
#define __GTK_ED_REFERENCE_H__

#include <editable/attributes/edreference.h>
#include "gtkentityform.h"
#include "gtkedattribute.h"

class GtkEdReference: public GtkEdAttribute {
public:
    GtkEdReference();
    virtual ~GtkEdReference();
    virtual void setAttribute(EditableAttribute *attrib);
    virtual void build();
    virtual GtkEdAttribute *clone() { return new GtkEdReference(); }
    virtual GtkWidget *getWidget() { return widget; }
    virtual bool needsLabel() { return false; }

    void newPointer();
    void removePointer();

    /// Selects another class for the changeClass operation
    void selectClass(std::string the_class);

    /// Instantiates the selected class referencing this new instance
    void changeClass();
private:
    void genClassesWindow();

    osg::ref_ptr<GtkEntityForm> entityForm;
    GtkWidget *widget;
    GtkWidget *frame2;
    osg::ref_ptr<EdReference> attribute;
    std::string selected_class;

    GtkWidget *selection_window;
};

#endif
