#include <config.h>
#include <local.h>
#include <iostream>
#include <gtk/gtk.h>
#include "gtkedreference.h"

static void genClassesWindow(EdReference *reference);

void on_remove_pointer_clicked (GtkButton       *button,
				GtkEdReference  *editor) {
    editor->removePointer();
}


void on_new_pointer_clicked (GtkButton       *button,
			     GtkEdReference  *editor) {
    editor->newPointer();
}

void on_cancel_clicked (GtkButton       *button,
		        GtkWidget *win)
{
    gtk_widget_destroy(win);
}


void on_ok_clicked     (GtkButton       *button,
		        GtkEdReference *ed)
{
    ed->changeClass();
}

class MyContainer{
public:
    osg::ref_ptr<GtkEdReference> ed;
    std::string name;
    MyContainer(GtkEdReference *ed, std::string name) {
	this->ed=ed; this->name=name;
    }
};

void on_class_toggled (GtkToggleButton *togglebutton,
		       MyContainer *c)
{
    if (togglebutton->active) {
	c->ed->selectClass(c->name);
    }
}

void GtkEdReference::changeClass() {
    attribute->set(selected_class);
    if (selection_window!=0) gtk_widget_destroy(selection_window);
    selection_window=0;

    EditableEntity *entity=attribute->get();
    if (entity != 0) {
	entityForm=new GtkEntityForm(entity);
	gtk_container_add (GTK_CONTAINER (frame2), entityForm->getWidget());
    } else {
	std::cerr << "GtkEdReference::changeClass: FATAL ERROR: I'm changing with a null!" << std::endl;
    }
}

void GtkEdReference::selectClass(std::string the_class) {
    this->selected_class=the_class;
}

void GtkEdReference::setAttribute(EditableAttribute *attrib) {
    if (widget ==0 ) {
	std::cerr << "setAttribute MUST be called after build()" << std::endl;
	throw -1;
    }
    attribute = dynamic_cast<EdReference*>(attrib);
    if (!attribute.valid()) {
	std::cerr << "GtkEdReference::build: FATAL ERROR: argument isn't an EdReference" << std::endl;
        throw -1;
    }

    EditableEntity *entity=attribute->get();
    if (entity != 0) {
	entityForm=new GtkEntityForm(entity);
	gtk_container_add (GTK_CONTAINER (frame2), entityForm->getWidget());
    }
    if (attribute->getClasses().size()) {
	this->selected_class=attribute->getClasses()[0];
    }
}

void GtkEdReference::build() {
    widget = gtk_frame_new (NULL);
    gtk_frame_set_shadow_type (GTK_FRAME (widget), GTK_SHADOW_NONE);

    GtkWidget *vbox1 = gtk_vbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (widget), vbox1);
    gtk_container_set_border_width (GTK_CONTAINER (vbox1), 10);

    frame2 = gtk_frame_new (NULL);
    gtk_box_pack_start (GTK_BOX (vbox1), frame2, TRUE, TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (frame2), 0);
    gtk_frame_set_shadow_type (GTK_FRAME (frame2), GTK_SHADOW_NONE);

    GtkWidget *hbox1 = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, TRUE, 0);

    GtkWidget *label1 = gtk_label_new ("");
    gtk_label_set_markup(GTK_LABEL(label1),_("<b>Reference</b>"));
    gtk_frame_set_label_widget (GTK_FRAME (widget), label1);
    gtk_label_set_justify (GTK_LABEL (label1), GTK_JUSTIFY_LEFT);

    GtkWidget *remove_pointer = gtk_button_new ();
    gtk_box_pack_end (GTK_BOX (hbox1), remove_pointer, FALSE, FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (remove_pointer), 2);

    GtkWidget *alignment2 = gtk_alignment_new (0.5, 0.5, 0, 0);
    gtk_container_add (GTK_CONTAINER (remove_pointer), alignment2);

    GtkWidget *hbox3 = gtk_hbox_new (FALSE, 2);
    gtk_container_add (GTK_CONTAINER (alignment2), hbox3);

    GtkWidget *r_pointer = gtk_image_new_from_stock ("gtk-delete", GTK_ICON_SIZE_BUTTON);
    gtk_box_pack_start (GTK_BOX (hbox3), r_pointer, FALSE, FALSE, 0);

    GtkWidget *label4 = gtk_label_new_with_mnemonic (_("Remove"));
    gtk_box_pack_start (GTK_BOX (hbox3), label4, FALSE, FALSE, 0);
    gtk_label_set_justify (GTK_LABEL (label4), GTK_JUSTIFY_LEFT);

    GtkWidget *new_pointer = gtk_button_new ();
    gtk_box_pack_end (GTK_BOX (hbox1), new_pointer, FALSE, FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (new_pointer), 2);

    GtkWidget *alignment1 = gtk_alignment_new (0.5, 0.5, 0, 0);
    gtk_container_add (GTK_CONTAINER (new_pointer), alignment1);

    GtkWidget *hbox2 = gtk_hbox_new (FALSE, 2);
    gtk_container_add (GTK_CONTAINER (alignment1), hbox2);

    GtkWidget *image1 = gtk_image_new_from_stock ("gtk-new", GTK_ICON_SIZE_BUTTON);
    gtk_box_pack_start (GTK_BOX (hbox2), image1, FALSE, FALSE, 0);

    GtkWidget *label3 = gtk_label_new_with_mnemonic (_("New"));
    gtk_box_pack_start (GTK_BOX (hbox2), label3, FALSE, FALSE, 0);
    gtk_label_set_justify (GTK_LABEL (label3), GTK_JUSTIFY_LEFT);

    g_signal_connect ((gpointer) remove_pointer, "clicked",
		      G_CALLBACK (on_remove_pointer_clicked),
		      this);
    g_signal_connect ((gpointer) new_pointer, "clicked",
		      G_CALLBACK (on_new_pointer_clicked),
		      this);

    gtk_widget_show_all(widget);
    gtk_widget_ref(widget);
}

GtkEdReference::GtkEdReference() {
    widget=0;
    selection_window=0;
}

GtkEdReference::~GtkEdReference() {
    if (widget!=0) gtk_widget_unref(widget);
    if (selection_window!=0) gtk_widget_destroy(selection_window);
}


void GtkEdReference::newPointer() {
    genClassesWindow();
}

void GtkEdReference::removePointer() {
    if (attribute->get() != NULL) {
	gtk_container_remove(GTK_CONTAINER (frame2), entityForm->getWidget());
	attribute->setNull();
    }
}

void GtkEdReference::genClassesWindow() {
    GtkWidget *window1;
    GtkWidget *vbox1;
    GtkWidget *frame2;
    GtkWidget *vbox2;
    GSList *class_group = NULL;
    GtkWidget *label4;
    GtkWidget *hbox3;
    GtkWidget *cancel;
    GtkWidget *alignment3;
    GtkWidget *hbox5;
    GtkWidget *image2;
    GtkWidget *label6;
    GtkWidget *ok;
    GtkWidget *alignment2;
    GtkWidget *hbox4;
    GtkWidget *image1;
    GtkWidget *label5;

    window1 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title (GTK_WINDOW (window1), _("Class selection"));

    vbox1 = gtk_vbox_new (FALSE, 0);
    gtk_widget_show (vbox1);
    gtk_container_add (GTK_CONTAINER (window1), vbox1);

    frame2 = gtk_frame_new (NULL);
    gtk_widget_show (frame2);
    gtk_box_pack_start (GTK_BOX (vbox1), frame2, TRUE, TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (frame2), 5);

    vbox2 = gtk_vbox_new (FALSE, 0);
    gtk_widget_show (vbox2);
    gtk_container_add (GTK_CONTAINER (frame2), vbox2);
    gtk_container_set_border_width (GTK_CONTAINER (vbox2), 5);

    std::vector<std::string> classes=attribute->getClasses();
    for (unsigned i=0;i<classes.size();i++) {
	GtkWidget *class1 = gtk_radio_button_new_with_mnemonic (NULL, classes[i].c_str());
	gtk_box_pack_start (GTK_BOX (vbox2), class1, FALSE, FALSE, 0);
	gtk_widget_show(class1);
	gtk_radio_button_set_group (GTK_RADIO_BUTTON (class1), class_group);
	class_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (class1));

	if (classes[i] == selected_class) {
            gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(class1), TRUE);
	}

	g_signal_connect ((gpointer) class1, "toggled",
			  G_CALLBACK (on_class_toggled),
			  new MyContainer(this,classes[i]));
   }

    label4 = gtk_label_new (_("Possible classes"));
    gtk_widget_show (label4);
    gtk_frame_set_label_widget (GTK_FRAME (frame2), label4);
    gtk_label_set_justify (GTK_LABEL (label4), GTK_JUSTIFY_LEFT);

    hbox3 = gtk_hbox_new (FALSE, 0);
    gtk_widget_show (hbox3);
    gtk_box_pack_start (GTK_BOX (vbox1), hbox3, FALSE, TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (hbox3), 5);

    cancel = gtk_button_new ();
    gtk_widget_show (cancel);
    gtk_box_pack_end (GTK_BOX (hbox3), cancel, FALSE, FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (cancel), 3);

    alignment3 = gtk_alignment_new (0.5, 0.5, 0, 0);
    gtk_widget_show (alignment3);
    gtk_container_add (GTK_CONTAINER (cancel), alignment3);

    hbox5 = gtk_hbox_new (FALSE, 2);
    gtk_widget_show (hbox5);
    gtk_container_add (GTK_CONTAINER (alignment3), hbox5);

    image2 = gtk_image_new_from_stock ("gtk-cancel", GTK_ICON_SIZE_BUTTON);
    gtk_widget_show (image2);
    gtk_box_pack_start (GTK_BOX (hbox5), image2, FALSE, FALSE, 0);

    label6 = gtk_label_new_with_mnemonic (_("Cancel"));
    gtk_widget_show (label6);
    gtk_box_pack_start (GTK_BOX (hbox5), label6, FALSE, FALSE, 0);
    gtk_label_set_justify (GTK_LABEL (label6), GTK_JUSTIFY_LEFT);

    ok = gtk_button_new ();
    gtk_widget_show (ok);
    gtk_box_pack_end (GTK_BOX (hbox3), ok, FALSE, FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (ok), 3);

    alignment2 = gtk_alignment_new (0.5, 0.5, 0, 0);
    gtk_widget_show (alignment2);
    gtk_container_add (GTK_CONTAINER (ok), alignment2);

    hbox4 = gtk_hbox_new (FALSE, 2);
    gtk_widget_show (hbox4);
    gtk_container_add (GTK_CONTAINER (alignment2), hbox4);

    image1 = gtk_image_new_from_stock ("gtk-ok", GTK_ICON_SIZE_BUTTON);
    gtk_widget_show (image1);
    gtk_box_pack_start (GTK_BOX (hbox4), image1, FALSE, FALSE, 0);

    label5 = gtk_label_new_with_mnemonic (_("OK"));
    gtk_widget_show (label5);
    gtk_box_pack_start (GTK_BOX (hbox4), label5, FALSE, FALSE, 0);
    gtk_label_set_justify (GTK_LABEL (label5), GTK_JUSTIFY_LEFT);

    g_signal_connect ((gpointer) cancel, "clicked",
		      G_CALLBACK (on_cancel_clicked),
		      window1);
    g_signal_connect ((gpointer) ok, "clicked",
		      G_CALLBACK (on_ok_clicked),
		      this);
    gtk_widget_show(window1);
    gtk_widget_ref(window1);
    selection_window=window1;
}
