#include <iostream>
#include <gtk/gtkframe.h>
#include <gtk/gtktable.h>
#include <gtk/gtkspinbutton.h>
#include <gtk/gtklabel.h>
#include "gtkedmatrix.h"

class MyCallbackData {
public:
    GtkEdMatrix *edmatrix;
    unsigned i,j;
    MyCallbackData(GtkEdMatrix *edmatrix, unsigned i, unsigned j) {
        this->edmatrix=edmatrix; this->i=i; this->j=j;
    }
};

static void callback (GtkAdjustment *adjustment,
		      MyCallbackData *data) {
    data->edmatrix->signal_changed(data->i, data->j);
}


void GtkEdMatrix::setAttribute(EditableAttribute *attrib) {
    attribute=dynamic_cast<EdMatrix*>(attrib);
    if (!attribute.valid()) {
	std::cerr << "GtkEdMatrix::build: FATAL ERROR: argument isn't an EdMatrix" << std::endl;
        throw -1;
    }

    if (widget ==0 ) {
	std::cerr << "setAttribute MUST be called after build()" << std::endl;
	throw -1;
    }
    if (handler_assigned) {
	for (unsigned j=0;j<4;j++) {
	    for (unsigned i=0;i<4;i++) {
		g_signal_handler_disconnect((gpointer) spin[i][j], handler_id[i][j]);
	    }
	}
    }
    osg::Matrix matrix = attribute->get();
    for (unsigned j=0;j<4;j++) {
	for (unsigned i=0;i<4;i++) {
	    gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin[i][j]), (gdouble)matrix(i,j));
	    handler_id[i][j] = g_signal_connect ((gpointer) spin[i][j], "changed",
						 G_CALLBACK (callback),
						 new MyCallbackData(this,i,j));
	}
    }
    handler_assigned=true;
    gtk_frame_set_label (GTK_FRAME (widget), attribute->getName().c_str());
}

void GtkEdMatrix::build() {
    widget = gtk_frame_new (NULL);
    GtkWidget *table = gtk_table_new (4, 4, FALSE);
    gtk_container_set_border_width (GTK_CONTAINER (table), 5);
    gtk_container_add(GTK_CONTAINER(widget), table);
    for (unsigned j=0;j<4;j++) {
	for (unsigned i=0;i<4;i++) {
	    GtkObject *widget_adj = gtk_adjustment_new (0,
							-G_MAXFLOAT,
							G_MAXFLOAT, 1, 10, 10);
	    spin[i][j] = gtk_spin_button_new (GTK_ADJUSTMENT (widget_adj), 1, 3);
	    gtk_table_attach (GTK_TABLE (table), spin[i][j], i, i+1, j, j+1,
			      (GtkAttachOptions) (GTK_EXPAND|GTK_FILL),
			      (GtkAttachOptions) (0), 0, 0);
	}
    }
    gtk_widget_ref(widget);
}

GtkEdMatrix::GtkEdMatrix() {
    widget=0;
    handler_assigned=false;
}

GtkEdMatrix::~GtkEdMatrix() {
    if (widget!=0) gtk_widget_unref(widget);
}

void GtkEdMatrix::signal_changed(int i, int j) {
    osg::Matrix v = attribute->get();
    GtkAdjustment *widget_adj=gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(spin[i][j]));
    v(i,j)=gtk_adjustment_get_value(GTK_ADJUSTMENT(widget_adj));
    attribute->set(v);
}
