#ifndef __GTK_ED_LIST_H__
#define __GTK_ED_LIST_H__

#include <editable/attributes/edlist.h>
#include "gtkedattribute.h"

class GtkEdList: public GtkEdAttribute, public EditableAttribute::Observer {
public:
    GtkEdList();
    virtual ~GtkEdList();
    virtual void setAttribute(EditableAttribute *attrib);
    virtual void build();
    virtual GtkEdAttribute *clone() { return new GtkEdList(); }
    virtual GtkWidget *getWidget() { return widget; }

    // We handle labeling ourselves
    virtual bool needsLabel() { return false; }

    void select(int row);

    /// it's an observer of editable attributes...
    virtual void attributeChanged(EditableAttribute *source);
private:
    GtkWidget *widget;
    GtkWidget *editables;
    GtkWidget *tree;
    osg::ref_ptr<EdList> attribute;

    /** We need this list to keep references to the active sub-editors and
     * implicitly delete them when this one is deleted */
    EditorList attribute_editors;

    EditableAttributeList observed; // To be able to end observing
};

#endif
