#include <config.h>
#include <iostream>
#include <gtk/gtkspinbutton.h>
#include <gtk/gtkscrolledwindow.h>
#include <gtk/gtkliststore.h>
#include <gtk/gtktreeview.h>
#include <gtk/gtktreeselection.h>
#include <gtk/gtkvbox.h>
#include <gtk/gtkhbox.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkframe.h>
#include <gtk/gtkcellrenderertext.h>
#include "gtkedlist.h"
#include "gtkedfactory.h"
#include <local.h>

#define VERTICAL_SPACING 0
#define HORIZONTAL_SPACING 3


void GtkEdList::setAttribute(EditableAttribute *attrib) {
    attribute=dynamic_cast<EdList*>(attrib);
    if (!attribute.valid()) {
	std::cerr << "GtkEdList::build: FATAL ERROR: argument isn't an EdList" << std::endl;
        throw -1;
    }

    /** Putting a label to the frame */
    gtk_frame_set_label (GTK_FRAME (widget), attribute->getName().c_str());
    if (attribute->length() != 0) {
	const EditableAttributeList &attributes = attribute->get(0);
	EditableAttributeList::const_iterator iter;
        /* Creating the editors for the different attributes in a line */
	for (iter=attributes.begin(); iter!=attributes.end(); iter++) {
	    osg::ref_ptr<EditableAttribute> attribute = *iter;
	    GtkWidget *hbox = gtk_hbox_new (FALSE, HORIZONTAL_SPACING);
	    gtk_box_pack_start (GTK_BOX (editables), hbox, TRUE, TRUE, 0);
	    GtkWidget *label = gtk_label_new (attribute->getName().c_str());
	    gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, FALSE, 0);
	    gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
	    GtkEdAttribute *editor = GtkEdFactory::instance()->find(attribute.get());
	    attribute_editors.push_back(editor);
	    editor->build();
	    //editor->setAttribute(attribute.get());
	    GtkWidget *editor_widget=editor->getWidget();
	    gtk_box_pack_start (GTK_BOX (hbox), editor_widget, FALSE, FALSE, 0);
	}
        /* Defining data types of the GTK data model */
	GType *types=new GType[attributes.size()+2];
        types[0]=G_TYPE_INT;
	for (unsigned i=1;i<attributes.size()+2; i++) {
            types[i]=G_TYPE_STRING;
	}
        /* Iserting data into the GTK data model */
	GtkListStore *store = gtk_list_store_newv (attributes.size()+2, types);
	for (unsigned line=0; line <attribute->length(); line++) {
	    const EditableAttributeList &attributes = attribute->get(line);
	    GtkTreeIter iter;
	    gtk_list_store_append(store,&iter);
            gtk_list_store_set(store,&iter,0, line, -1);
            gtk_list_store_set(store,&iter,1, attribute->getItemName(line).c_str(), -1);
	    for (unsigned i=2;i<attributes.size()+2; i++) {
		gtk_list_store_set(store,&iter,i,attributes[i-2]->toString().c_str(), -1);
	    }
	}
	gtk_tree_view_set_model(GTK_TREE_VIEW(tree),GTK_TREE_MODEL(store));

	/* Defining tree view renderers */
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;

	for (unsigned i=0;i<=attributes.size();i++) {
	    renderer = gtk_cell_renderer_text_new();
	    std::string name;
	    if (i==0) name=_("Item");
            else name=attributes[i-1]->getName();
	    column=gtk_tree_view_column_new_with_attributes (name.c_str(),
							     renderer,
							     "text", i+1,
							     NULL);
	    gtk_tree_view_append_column (GTK_TREE_VIEW(tree), column);
	}

    }

}

static void
tree_selection_changed_cb (GtkTreeSelection *selection, gpointer data) {
    GtkEdList *edlist=(GtkEdList*)data;

    GtkTreeIter iter;
    GtkTreeModel *model;
    if (gtk_tree_selection_get_selected (selection, &model, &iter)) {
        int row;
	gtk_tree_model_get (model, &iter, 0, &row, -1);
        edlist->select(row);
    }

}

void GtkEdList::select(int row) {
    EditableAttributeList::iterator iter_obs;
    for (iter_obs=observed.begin();iter_obs!=observed.end();iter_obs++) {
	EditableAttribute *attr=iter_obs->get();
        attr->removeObserver(this);
    }
    while(observed.size()) observed.erase(observed.begin());
    /* Setting the new editable attributes for the editors */
    const EditableAttributeList &attributes = attribute->get(row);
    EditableAttributeList::const_iterator iter;
    EditorList::iterator iter_editor=attribute_editors.begin();
    for (iter=attributes.begin(); iter!=attributes.end(); iter++, iter_editor++) {
	osg::ref_ptr<EditableAttribute> attribute = *iter;
	osg::ref_ptr<GtkEdAttribute> editor = *iter_editor;
	editor->setAttribute(attribute.get());
	observed.push_back(attribute);
        attribute->addObserver(this);
    }
}

void GtkEdList::build() {
    widget = gtk_frame_new (NULL);

    GtkWidget *vbox1 = gtk_vbox_new (FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (vbox1), 5);
    gtk_container_add (GTK_CONTAINER (widget), vbox1);

    GtkWidget *scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
    gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow1, TRUE, TRUE, 0);

    tree = gtk_tree_view_new ();
    gtk_container_add (GTK_CONTAINER (scrolledwindow1), tree);

    GtkTreeSelection *select;

    select = gtk_tree_view_get_selection (GTK_TREE_VIEW (tree));
    g_signal_connect (G_OBJECT (select), "changed",
		      G_CALLBACK (tree_selection_changed_cb),this);


    editables = gtk_vbox_new (FALSE, VERTICAL_SPACING);
    gtk_container_add (GTK_CONTAINER (vbox1), editables);


    gtk_widget_ref(widget);
}

GtkEdList::GtkEdList() {
    widget=0;
    tree=0;
    editables=0;
}

GtkEdList::~GtkEdList() {
    if (widget!=0) gtk_widget_unref(widget);
}

void GtkEdList::attributeChanged(EditableAttribute *source) {
    GtkTreeSelection *selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(tree));
    GtkTreeIter iter;
    GtkTreeModel *model;
    if (gtk_tree_selection_get_selected (selection, &model, &iter)) {
	for (unsigned i=0;i<observed.size();i++) {
	    if (observed[i] == source) {
		gtk_list_store_set (GTK_LIST_STORE(model), &iter, 2+i, source->toString().c_str(), -1);
	    }
	}
    }
}
